/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.handler;

import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xueluoanping.fluiddrawerslegacy.capability.CapabilityProvider_FluidControllerProxy;
import xueluoanping.fluiddrawerslegacy.capability.CapabilityProvider_FluidDrawerController;

public class ControllerFluidCapabilityHandler {
    public static final ControllerFluidCapabilityHandler instance = new ControllerFluidCapabilityHandler();
    private static final ResourceLocation CAP_FLUID_CTRL = new ResourceLocation("fluiddrawerslegacy", "fluid_ctrl");
    private static final ResourceLocation CAP_FLUID_PROXY = new ResourceLocation("fluiddrawerslegacy", "fluid_proxy");

    @SubscribeEvent
    public void onTileCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity tile = (BlockEntity)event.getObject();
        if (tile instanceof TileEntityController) {
            event.addCapability(CAP_FLUID_CTRL, (ICapabilityProvider)new CapabilityProvider_FluidDrawerController((TileEntityController)tile));
        } else if (tile instanceof TileEntitySlave) {
            event.addCapability(CAP_FLUID_PROXY, (ICapabilityProvider)new CapabilityProvider_FluidControllerProxy((TileEntitySlave)tile));
        }
    }

    @SubscribeEvent
    public void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getWorld();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != ModBlocks.CONTROLLER.get() || face != state.m_61143_((Property)BlockController.f_54117_)) {
            return;
        }
        if (ControllerFluidCapabilityHandler.handleTankInteraction(world.m_7702_(pos), face, event.getPlayer(), event.getHand()).get()) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    public static AtomicBoolean handleTankInteraction(@Nullable BlockEntity tile, @Nullable Direction face, Player player, InteractionHand hand) {
        AtomicBoolean result = new AtomicBoolean(false);
        if (tile.m_58904_().m_5776_()) {
            return new AtomicBoolean(false);
        }
        if (!(tile instanceof TileEntityController) || !tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent()) {
            return result;
        }
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41720_() instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)heldStack.m_41720_();
            if (bucketItem.getFluid() == Fluids.f_76191_) {
                return result;
            }
            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).ifPresent(handler -> {
                if (1000 == handler.fill(new FluidStack(bucketItem.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE) && !player.m_7500_()) {
                    player.m_21008_(hand, heldStack.getContainerItem());
                }
                result.set(true);
            });
            return result;
        }
        tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).ifPresent(handler -> {
            CapabilityProvider_FluidDrawerController.betterFluidHandler betterFluidHandler2 = (CapabilityProvider_FluidDrawerController.betterFluidHandler)((Object)handler);
            heldStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(itemFluidHandler -> {
                if (betterFluidHandler2.fill(itemFluidHandler.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE) > 0) {
                    result.set(true);
                }
            });
        });
        return result;
    }
}

