/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.unobtainium.api.helper;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import xyz.iwolfking.unobtainium.api.lib.inventory.SimpleContainerWithSlots;
import xyz.iwolfking.unobtainium.api.lib.tooltip.ContainerItemTooltip;

public class ContainerItemHelper {
    public static SimpleContainer loadItemContainer(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, int containerRows) {
        CompoundTag compoundtag = ContainerItemHelper.getDataTagFromItem(stack, blockEntityType);
        SimpleContainerWithSlots simpleContainer = new SimpleContainerWithSlots(containerRows);
        if (compoundtag != null && compoundtag.m_128441_("Items")) {
            simpleContainer.m_7797_(compoundtag.m_128437_("Items", 10));
        }
        simpleContainer.m_19164_(container -> ContainerItemHelper.saveItemContainer(stack, blockEntityType, (SimpleContainer)container));
        return simpleContainer;
    }

    private static void saveItemContainer(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, SimpleContainer container) {
        ListTag listTag = container.m_7927_();
        if (blockEntityType == null) {
            if (listTag.isEmpty()) {
                stack.m_41749_("Items");
            } else {
                stack.m_41700_("Items", (Tag)listTag);
            }
        } else {
            CompoundTag tag = new CompoundTag();
            if (!listTag.isEmpty()) {
                tag.m_128365_("Items", (Tag)listTag);
            }
            BlockItem.m_186338_((ItemStack)stack, blockEntityType, (CompoundTag)tag);
        }
    }

    public static boolean overrideStackedOnOther(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, int containerRows, Slot slot, ClickAction clickAction, Player player, Predicate<ItemStack> itemFilter, SoundEvent insertSound, SoundEvent removeSound) {
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack hoveredStack = slot.m_7993_();
        if (hoveredStack.m_41619_()) {
            ContainerItemHelper.removeLastStack(stack, blockEntityType, containerRows).ifPresent(stack1 -> {
                player.m_5496_(removeSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                ContainerItemHelper.addStack(stack1, blockEntityType, containerRows, slot.m_150659_(stack1), itemFilter);
            });
        } else {
            hoveredStack = slot.m_150647_(hoveredStack.m_41613_(), hoveredStack.m_41613_(), player);
            int transferredCount = ContainerItemHelper.addStack(stack, blockEntityType, containerRows, hoveredStack, itemFilter);
            hoveredStack.m_41774_(transferredCount);
            if (!hoveredStack.m_41619_()) {
                slot.m_150659_(hoveredStack);
            }
            if (transferredCount > 0) {
                player.m_5496_(insertSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
            }
        }
        return true;
    }

    public static boolean overrideOtherStackedOnMe(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, int containerRows, ItemStack stackOnMe, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess, Predicate<ItemStack> itemFilter, SoundEvent insertSound, SoundEvent removeSound) {
        if (clickAction != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stackOnMe.m_41619_()) {
            ContainerItemHelper.removeLastStack(stack, blockEntityType, containerRows).ifPresent(p_186347_ -> {
                player.m_5496_(removeSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                slotAccess.m_142104_(p_186347_);
            });
        } else {
            int transferredCount = ContainerItemHelper.addStack(stack, blockEntityType, containerRows, stackOnMe, itemFilter);
            if (transferredCount > 0) {
                player.m_5496_(insertSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                stackOnMe.m_41774_(transferredCount);
            }
        }
        return true;
    }

    private static int addStack(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, int containerRows, ItemStack newStack, Predicate<ItemStack> itemFilter) {
        if (newStack.m_41619_() || !itemFilter.test(newStack)) {
            return 0;
        }
        SimpleContainer container = ContainerItemHelper.loadItemContainer(stack, blockEntityType, containerRows);
        ItemStack remainingStack = container.m_19173_(newStack);
        while (!remainingStack.m_41619_() && container.m_19183_(remainingStack)) {
            remainingStack = container.m_19173_(remainingStack);
        }
        return newStack.m_41613_() - remainingStack.m_41613_();
    }

    private static Optional<ItemStack> removeLastStack(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, int containerRows) {
        SimpleContainer container = ContainerItemHelper.loadItemContainer(stack, blockEntityType, containerRows);
        for (int i = container.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack1 = container.m_8020_(i);
            if (stack1.m_41619_()) continue;
            return Optional.of(container.m_7407_(i, stack1.m_41613_()));
        }
        return Optional.empty();
    }

    public static Optional<TooltipComponent> getTooltipImage(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType, int containerRows, @Nullable DyeColor backgroundColor) {
        CompoundTag compoundtag = ContainerItemHelper.getDataTagFromItem(stack, blockEntityType);
        if (compoundtag == null || !compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        NonNullList items = NonNullList.m_122779_();
        SimpleContainer container = ContainerItemHelper.loadItemContainer(stack, blockEntityType, containerRows);
        for (int i = 0; i < container.m_6643_(); ++i) {
            items.add((Object)container.m_8020_(i));
        }
        return Optional.of(new ContainerItemTooltip((NonNullList<ItemStack>)items, containerRows, backgroundColor));
    }

    @Nullable
    private static CompoundTag getDataTagFromItem(ItemStack stack, @Nullable BlockEntityType<?> blockEntityType) {
        if (blockEntityType != null) {
            return BlockItem.m_186336_((ItemStack)stack);
        }
        return stack.m_41783_();
    }
}

