/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.unobtainium.integration;

import java.io.IOException;
import java.io.InputStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.LoadingModList;
import xyz.iwolfking.unobtainium.Unobtanium;
import xyz.iwolfking.vhapi.api.events.VHAPIProcessorsEvent;
import xyz.iwolfking.vhapi.api.util.VHAPIProcesserUtils;

public class VHAPIConfigRegistration {
    public static void addManualConfigs() {
        Unobtanium.LOGGER.info("Registering Vault config patches!");
        if (LoadingModList.get().getModFileById("woldsvaults") != null) {
            Unobtanium.LOGGER.info("Wold's Vaults is present, disabling VHAPI configs from loading.");
            return;
        }
        VHAPIConfigRegistration.registerManualConfigFile("/config_patches/more_mobs_brazier_fix.json", Unobtanium.id("vault/modifier_pools/more_mobs_brazier_patch"));
    }

    public static void registerManualConfigFile(String filePath, ResourceLocation vhapiRegistryId) {
        try (InputStream stream = Unobtanium.class.getResourceAsStream(filePath);){
            if (stream == null) {
                throw new IOException();
            }
            VHAPIProcesserUtils.addManualConfigFile((InputStream)stream, (ResourceLocation)vhapiRegistryId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void onVHAPIProcessorEnd(VHAPIProcessorsEvent.End event) {
        VHAPIConfigRegistration.addManualConfigs();
    }
}

