/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.comforts.ComfortsMod;

public class ComfortsConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.comforts.config.";
    public static boolean autoUse;
    public static boolean wellRested;
    public static double sleepyFactor;
    public static boolean nightHammocks;
    public static double sleepingBagBreakage;
    public static List<MobEffectInstance> sleepingBagDebuffs;
    public static boolean insulatedSleepingBag;

    public static void bake() {
        autoUse = (Boolean)ComfortsConfig.SERVER.autoUse.get();
        wellRested = (Boolean)ComfortsConfig.SERVER.wellRested.get();
        sleepyFactor = (Double)ComfortsConfig.SERVER.sleepyFactor.get();
        nightHammocks = (Boolean)ComfortsConfig.SERVER.nightHammocks.get();
        sleepingBagBreakage = (Double)ComfortsConfig.SERVER.sleepingBagBreakage.get();
        sleepingBagDebuffs = new ArrayList<MobEffectInstance>();
        insulatedSleepingBag = (Boolean)ComfortsConfig.SERVER.insulatedSleepingBag.get();
        ((List)ComfortsConfig.SERVER.sleepingBagDebuffs.get()).forEach(debuff -> {
            String[] elements = debuff.split("\\s+");
            MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(elements[0]));
            if (potion == null) {
                return;
            }
            int duration = 0;
            int amp = 0;
            try {
                duration = Math.max(1, Math.min(Integer.parseInt(elements[1]), 1600));
                amp = Math.max(1, Math.min(Integer.parseInt(elements[2]), 4));
            }
            catch (Exception e) {
                ComfortsMod.LOGGER.error("Problem parsing sleeping bag debuffs in config!", (Throwable)e);
            }
            sleepingBagDebuffs.add(new MobEffectInstance(potion, duration * 20, amp - 1));
        });
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue autoUse;
        public final ForgeConfigSpec.BooleanValue wellRested;
        public final ForgeConfigSpec.DoubleValue sleepyFactor;
        public final ForgeConfigSpec.BooleanValue nightHammocks;
        public final ForgeConfigSpec.DoubleValue sleepingBagBreakage;
        public final ForgeConfigSpec.ConfigValue<List<String>> sleepingBagDebuffs;
        public final ForgeConfigSpec.BooleanValue insulatedSleepingBag;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            this.autoUse = builder.comment("Set to true to automatically use sleeping bags when placed").translation("gui.comforts.config.autoUse").define("autoUse", true);
            this.wellRested = builder.comment("Set to true to prevent sleeping depending on how long you previously slept").translation("gui.comforts.config.wellRested").define("wellRested", false);
            this.sleepyFactor = builder.comment("If well rested is true, this value is used to determine how long you need before being able to sleep again (larger numbers = can sleep sooner)").translation("gui.comforts.config.sleepyFactor").defineInRange("sleepyFactor", 2.0, 1.0, 20.0);
            this.nightHammocks = builder.comment("Set to true to enable sleeping in hammocks at night").translation("gui.comforts.config.nightHammocks").define("nightHammocks", false);
            this.sleepingBagBreakage = builder.comment("The chance that a sleeping bag will break upon usage").translation("gui.comforts.config.sleepingBagBreakage").defineInRange("sleepingBagBreakage", 0.0, 0.0, 1.0);
            this.sleepingBagDebuffs = builder.comment("List of debuffs to apply to players after using the sleeping bag\nFormat: [effect] [duration(secs)] [power]").translation("gui.comforts.config.sleepingBagDebuffs").worldRestart().define("sleepingBagDebuffs", new ArrayList());
            this.insulatedSleepingBag = builder.comment("[Survive Mod Integration] Set to true to have sleeping bags increase your body temperature after sleeping").translation("gui.comforts.config.insulatedSleepingBag").define("insulatedSleepingBag", false);
        }
    }
}

