/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.capability.ItemHandlerCapabilityProvider;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractRandomizerBagItem
extends Item {
    private static long currentSeed = 1337L;
    private static final Random rand = new Random(currentSeed);

    public AbstractRandomizerBagItem() {
        super(new Item.Properties().m_41491_(CreativeModeTab.f_40756_).m_41487_(1));
    }

    public abstract int getInventorySize();

    public abstract MenuProvider getContainerProvider(ItemStack var1);

    public IItemHandler getBagInventory(ItemStack bag) {
        return (IItemHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
    }

    public ItemStack pickRandomStack(IItemHandler bagInventory) {
        int nonempty = 0;
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();
        ArrayList<Integer> originalSlots = new ArrayList<Integer>(this.getInventorySize());
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ++nonempty;
            nonEmptyStacks.add(stack);
            originalSlots.add(i);
        }
        if (nonEmptyStacks.size() != originalSlots.size()) {
            throw new Error("NonEmptyStacks and OriginalSlots not same size");
        }
        if (nonempty == 0) {
            return ItemStack.f_41583_;
        }
        int randomSlot = rand.nextInt(nonempty);
        if (randomSlot < 0 || randomSlot > bagInventory.getSlots()) {
            return ItemStack.f_41583_;
        }
        int originalSlot = (Integer)originalSlots.get(randomSlot);
        if (originalSlot < 0 || originalSlot > bagInventory.getSlots()) {
            return ItemStack.f_41583_;
        }
        return bagInventory.getStackInSlot(originalSlot);
    }

    public ItemStack findStack(IItemHandler bagInventory, Item item) {
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static void resetRandomness() {
        rand.setSeed(currentSeed);
    }

    public static void renewRandomness() {
        currentSeed = Calendar.getInstance().getTimeInMillis();
        rand.setSeed(currentSeed);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction facing = ctx.m_43719_();
        ItemStack item = ctx.m_43722_();
        Vec3 hitVec = ctx.m_43720_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (ctx.m_43723_() != null && ctx.m_43723_().m_6144_()) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getContainerProvider(item));
        } else {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(player).getBuildMode();
            ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
            if (buildMode != BuildModes.BuildModeEnum.NORMAL || modifierSettings.doQuickReplace()) {
                return InteractionResult.FAIL;
            }
            ItemStack bag = player.m_21120_(InteractionHand.MAIN_HAND);
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return InteractionResult.FAIL;
            }
            ItemStack toPlace = this.pickRandomStack(bagInventory);
            if (toPlace.m_41619_()) {
                return InteractionResult.FAIL;
            }
            if (!world.m_8055_(pos).m_60734_().m_5946_(world.m_8055_(pos), Fluids.f_76191_)) {
                pos = pos.m_142300_(facing);
            }
            BlockPlaceContext blockItemUseContext = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(hitVec, facing, pos, false)));
            BlockState blockState = Block.m_49814_((Item)toPlace.m_41720_()).m_5573_(blockItemUseContext);
            SurvivalHelper.placeBlock(world, player, pos, blockState, toPlace, facing, hitVec, false, false, true);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack bag = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (world.f_46443_) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)bag);
            }
        } else {
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)bag);
            }
            ItemStack toUse = this.pickRandomStack(bagInventory);
            if (toUse.m_41619_()) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)bag);
            }
            return toUse.m_41682_(world, player, hand);
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getContainerProvider(bag));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)bag);
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 1;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemHandlerCapabilityProvider(this.getInventorySize());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + "Rightclick" + ChatFormatting.GRAY + " to place a random block"));
        tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + "Sneak + rightclick" + ChatFormatting.GRAY + " to open inventory"));
        if (world != null && world.m_6907_().size() > 1) {
            tooltip.add((Component)new TextComponent(ChatFormatting.YELLOW + "Experimental on servers: may lose inventory"));
        }
    }

    public String m_5524_() {
        return this.getRegistryName().toString();
    }
}

