/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class EntangledBlockEntityRenderer
implements CustomBlockEntityRenderer<EntangledBlockEntity> {
    public static final TagKey<Block> BLACKLISTED_BLOCKS = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("entangled", "render_blacklist"));
    public static final TagKey<BlockEntityType<?>> BLACKLISTED_ENTITIES = TagKey.m_203882_((ResourceKey)Registry.f_122907_, (ResourceLocation)new ResourceLocation("entangled", "render_blacklist"));
    private static final Set<BlockEntityType<?>> ERRORED_BLOCK_ENTITIES = Collections.synchronizedSet(new HashSet());
    private static final Set<BlockState> ERRORED_BLOCK_STATES = Collections.synchronizedSet(new HashSet());
    private static int depth = 0;

    public void render(EntangledBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        VoxelShape shape;
        if (!entity.isBound()) {
            return;
        }
        BlockEntity boundTile = entity.m_58904_().m_46472_() == entity.getBoundDimensionIdentifier() ? entity.m_58904_().m_7702_(entity.getBoundBlockPos()) : null;
        BlockState boundState = entity.getBoundBlockState();
        boolean renderTile = boundTile != null && !ForgeRegistries.BLOCK_ENTITIES.tags().getTag(BLACKLISTED_ENTITIES).contains((Object)boundTile.m_58903_()) && !ERRORED_BLOCK_ENTITIES.contains(boundTile.m_58903_());
        boolean renderBlock = boundState != null && boundState.m_60799_() == RenderShape.MODEL && !boundState.m_204336_(BLACKLISTED_BLOCKS) && !ERRORED_BLOCK_STATES.contains(boundState);
        AABB bounds = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (renderBlock && entity.m_58904_().m_46472_() == entity.getBoundDimensionIdentifier() && !(shape = boundState.m_60768_((BlockGetter)entity.m_58904_(), entity.getBoundBlockPos())).m_83281_()) {
            bounds = shape.m_83215_();
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        if (EntangledConfig.rotateRenderedBlock.get().booleanValue()) {
            float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 360.0f;
            float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 360.0f;
            float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 360.0f;
            poseStack.m_85845_(new Quaternion(angleX, angleY, angleZ, true));
        }
        float scale = 0.4763f / (float)Math.sqrt((bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_()) / 4.0);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_(-bounds.m_82399_().f_82479_, -bounds.m_82399_().f_82480_, -bounds.m_82399_().f_82481_);
        if (renderTile && (!(boundTile instanceof EntangledBlockEntity) || depth < 10)) {
            ++depth;
            try {
                ClientUtils.getMinecraft().m_167982_().m_112267_(boundTile, partialTicks, poseStack, bufferSource);
            }
            catch (Exception e) {
                ERRORED_BLOCK_ENTITIES.add(boundTile.m_58903_());
                Entangled.LOGGER.error("Encountered an exception whilst rendering block entity '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier((Object)boundTile.m_58903_()) + "'! Please report to Entangled!", (Throwable)e);
            }
            --depth;
        }
        if (renderBlock) {
            try {
                ClientUtils.getBlockRenderer().m_110912_(boundState, poseStack, bufferSource, combinedLight, combinedOverlay);
            }
            catch (Exception e) {
                ERRORED_BLOCK_STATES.add(boundState);
                Entangled.LOGGER.error("Encountered an exception whilst rendering block '" + boundState + "'! Please report to Entangled!", (Throwable)e);
            }
        }
        poseStack.m_85849_();
    }
}

