/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.mixin;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.chunk.IDistanceManager;
import com.betterchunkloading.chunk.IPlayerDataPlayer;
import com.betterchunkloading.chunk.PlayerChunkData;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DistanceManager.class})
public abstract class DistanceManagerMixin
implements IDistanceManager {
    @Shadow
    @Final
    private DistanceManager.PlayerTicketTracker f_140764_;
    @Shadow
    @Final
    private TickingTracker f_183901_;
    @Unique
    final Long2IntMap playerCountPerChunk = new Long2IntOpenHashMap();

    @Shadow
    protected abstract int m_183918_();

    @Override
    public Long2IntMap getPlayerCountPerChunk() {
        return this.playerCountPerChunk;
    }

    @Inject(method={"addPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V")}, cancellable=true)
    private void onAddPlayerToChunkSection(SectionPos chunkSection, ServerPlayer player, CallbackInfo ci) {
        if (!(player instanceof IPlayerDataPlayer)) {
            return;
        }
        ci.cancel();
        PlayerChunkData data = ((IPlayerDataPlayer)player).betterchunkloading$getPlayerChunkData();
        data.onChunkChanged(player);
        ChunkPos newTicketPos = data.getSlowAvgPos();
        if (newTicketPos != null && newTicketPos.equals((Object)data.getLazyLoadingLastTicketPos())) {
            return;
        }
        if (newTicketPos == null) {
            newTicketPos = player.m_146902_();
        }
        this.playerCountPerChunk.put(newTicketPos.m_45588_(), this.playerCountPerChunk.getOrDefault(newTicketPos.m_45588_(), 0) + 1);
        this.f_140764_.m_140715_(newTicketPos.m_45588_(), 0, true);
        this.f_183901_.m_184154_(TicketType.f_9444_, newTicketPos, this.m_183918_(), (Object)newTicketPos);
        data.setLazyLoadingLastTicketPos(newTicketPos);
    }

    @Inject(method={"removePlayer"}, at={@At(value="HEAD")})
    private void onRemovePlayerFromChunkSection(SectionPos chunkSection, ServerPlayer player, CallbackInfo ci) {
        if (!(player instanceof IPlayerDataPlayer)) {
            return;
        }
        PlayerChunkData data = ((IPlayerDataPlayer)player).betterchunkloading$getPlayerChunkData();
        data.onChunkChanged(player);
        ChunkPos avgTicketPos = data.getSlowAvgPos();
        if (avgTicketPos != null && avgTicketPos.equals((Object)data.getLazyLoadingLastTicketPos()) && !player.m_146910_()) {
            return;
        }
        this.betterchunkloading$removePlayer(data);
    }

    @Inject(method={"removePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$PlayerTicketTracker;update(JIZ)V")}, cancellable=true)
    private void betterchunkloading$skipRemovePlayer(SectionPos p_140829_, ServerPlayer p_140830_, CallbackInfo ci) {
        ci.cancel();
    }

    @Unique
    private void betterchunkloading$removePlayer(PlayerChunkData data) {
        ChunkPos toUnload = data.getLazyLoadingLastTicketPos();
        if (toUnload != null) {
            long posKey = toUnload.m_45588_();
            if (!this.playerCountPerChunk.containsKey(posKey)) {
                BetterChunkLoading.LOGGER.warn("missing player in chunk");
            }
            if (this.playerCountPerChunk.get(posKey) <= 1) {
                this.playerCountPerChunk.remove(posKey);
                this.f_140764_.m_140715_(posKey, Integer.MAX_VALUE, false);
                this.f_183901_.m_184168_(TicketType.f_9444_, toUnload, this.m_183918_(), (Object)toUnload);
            } else {
                this.playerCountPerChunk.put(toUnload.m_45588_(), this.playerCountPerChunk.getOrDefault(toUnload.m_45588_(), 0) - 1);
            }
            data.setLazyLoadingLastTicketPos(null);
        }
    }
}

