/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import immersive_paintings.Main;
import immersive_paintings.client.ClientUtils;
import immersive_paintings.client.gui.widget.CallbackCheckboxWidget;
import immersive_paintings.client.gui.widget.IntegerSliderWidget;
import immersive_paintings.client.gui.widget.PaintingWidget;
import immersive_paintings.client.gui.widget.PercentageSliderWidget;
import immersive_paintings.client.gui.widget.TexturedButtonWidget;
import immersive_paintings.client.gui.widget.TooltipButtonWidget;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.c2s.PaintingDeleteRequest;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.c2s.RegisterPaintingRequest;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Frame;
import immersive_paintings.resources.FrameLoader;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.FlowingText;
import immersive_paintings.util.ImageManipulations;
import immersive_paintings.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.StringConcatFactory;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ImmersivePaintingScreen
extends Screen {
    private static final int SCREENSHOTS_PER_PAGE = 5;
    final int entityId;
    final int minResolution;
    final int maxResolution;
    final boolean showOtherPlayersPaintings;
    final int uploadPermissionLevel;
    public final ImmersivePaintingEntity entity;
    private String filteredString = "";
    private int filteredResolution = 0;
    private int filteredWidth = 0;
    private int filteredHeight = 0;
    private final List<ResourceLocation> filteredPaintings = new ArrayList<ResourceLocation>();
    private int selectionPage;
    private Page page;
    private Button pageWidget;
    private final List<PaintingWidget> paintingWidgetList = new LinkedList<PaintingWidget>();
    private ByteImage currentImage;
    private static int currentImagePixelZoomCache = -1;
    private String currentImageName;
    private PixelatorSettings settings;
    private ByteImage pixelatedImage;
    private List<File> screenshots = List.of();
    private int screenshotPage;
    private ResourceLocation deletePainting;
    private TranslatableComponent error;
    private boolean shouldReProcess;
    private static volatile boolean shouldUpload;
    final ExecutorService service = Executors.newFixedThreadPool(1);

    public ImmersivePaintingScreen(int entityId, int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) {
        super((Component)new TranslatableComponent("item.immersive_paintings.painting"));
        ImmersivePaintingEntity painting;
        Entity entity;
        this.entityId = entityId;
        this.minResolution = minResolution;
        this.maxResolution = maxResolution;
        this.showOtherPlayersPaintings = showOtherPlayersPaintings;
        this.uploadPermissionLevel = uploadPermissionLevel;
        this.entity = Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(entityId)) instanceof ImmersivePaintingEntity ? (painting = (ImmersivePaintingEntity)entity) : null;
        if (this.entity == null) {
            this.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.page == null) {
            this.setPage(Page.DATAPACKS);
        } else {
            this.refreshPage();
        }
        File file = new File(Minecraft.m_91087_().f_91069_, "screenshots");
        File[] files = file.listFiles(v -> v.getName().endsWith(".png"));
        if (files != null) {
            this.screenshots = Arrays.stream(files).toList();
        }
    }

    private void clearSearch() {
        this.filteredString = "";
        this.filteredResolution = 0;
        this.filteredWidth = 0;
        this.filteredHeight = 0;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        switch (this.page) {
            case NEW: {
                ImmersivePaintingScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ / 2 - 115), (int)(this.f_96544_ / 2 - 68), (int)(this.f_96543_ / 2 + 115), (int)(this.f_96544_ / 2 - 41), (int)0x50000000);
                List<Component> wrap = FlowingText.wrap((Component)new TranslatableComponent("immersive_paintings.drop"), 220);
                int y = this.f_96544_ / 2 - 40 - wrap.size() * 12;
                for (Component text : wrap) {
                    ImmersivePaintingScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)text, (int)(this.f_96543_ / 2), (int)y, (int)-1);
                    y += 12;
                }
                break;
            }
            case CREATE: {
                if (this.shouldReProcess && this.currentImage != null) {
                    Runnable task = () -> {
                        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
                        shouldUpload = true;
                    };
                    this.service.submit(task);
                    this.shouldReProcess = false;
                }
                if (shouldUpload && this.pixelatedImage != null) {
                    Minecraft.m_91087_().m_91097_().m_118495_(Main.locate("temp_pixelated"), (AbstractTexture)new DynamicTexture(ClientUtils.byteImageToNativeImage(this.pixelatedImage)));
                }
                int maxWidth = 190;
                int maxHeight = 135;
                int tw = this.settings.resolution * this.settings.width;
                int th = this.settings.resolution * this.settings.height;
                float size = Math.min((float)maxWidth / (float)tw, (float)maxHeight / (float)th);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)Main.locate("temp_pixelated"));
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69482_();
                matrices.m_85836_();
                matrices.m_85837_((double)((float)this.f_96543_ / 2.0f - (float)tw * size / 2.0f), (double)((float)this.f_96544_ / 2.0f - (float)th * size / 2.0f), 0.0);
                matrices.m_85841_(size, size, 1.0f);
                ImmersivePaintingScreen.m_93133_((PoseStack)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)tw, (int)th, (int)tw, (int)th);
                matrices.m_85849_();
                if (this.error == null) break;
                ImmersivePaintingScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.error, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)-65536);
                break;
            }
            case DELETE: {
                ImmersivePaintingScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ / 2 - 160), (int)(this.f_96544_ / 2 - 50), (int)(this.f_96543_ / 2 + 160), (int)(this.f_96544_ / 2 + 50), (int)-2013265920);
                List<Component> wrap = FlowingText.wrap((Component)new TranslatableComponent("immersive_paintings.confirm_deletion"), 300);
                int y = this.f_96544_ / 2 - 35;
                for (Component t : wrap) {
                    ImmersivePaintingScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)t, (int)(this.f_96543_ / 2), (int)y, (int)0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case ADMIN_DELETE: {
                ImmersivePaintingScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ / 2 - 160), (int)(this.f_96544_ / 2 - 50), (int)(this.f_96543_ / 2 + 160), (int)(this.f_96544_ / 2 + 50), (int)-2013265920);
                List<Component> wrap = FlowingText.wrap((Component)new TranslatableComponent("immersive_paintings.confirm_admin_deletion"), 300);
                int y = this.f_96544_ / 2 - 35;
                for (Component t : wrap) {
                    ImmersivePaintingScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)t, (int)(this.f_96543_ / 2), (int)y, (int)0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case LOADING: {
                TranslatableComponent text = new TranslatableComponent("immersive_paintings.upload", new Object[]{(int)Math.ceil(LazyNetworkManager.getRemainingTime())});
                ImmersivePaintingScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)text, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)-1);
            }
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    private List<ResourceLocation> getMaterialsList() {
        return FrameLoader.frames.values().stream().filter(v -> v.frame().equals((Object)this.entity.getFrame())).map(Frame::material).distinct().sorted(ResourceLocation::compareTo).toList();
    }

    private void rebuild() {
        int x;
        this.m_169413_();
        if (this.page != Page.CREATE) {
            LinkedList<Page> b2 = new LinkedList<Page>();
            b2.add(Page.YOURS);
            b2.add(Page.DATAPACKS);
            if (this.showOtherPlayersPaintings || this.isOp()) {
                b2.add(Page.PLAYERS);
            }
            if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.m_20310_(this.uploadPermissionLevel)) {
                b2.add(Page.NEW);
            }
            if (!this.entity.isGraffiti()) {
                b2.add(Page.FRAME);
            }
            x = this.f_96543_ / 2 - 200;
            int w = 400 / b2.size();
            for (Page page : b2) {
                ((Button)this.m_142416_((GuiEventListener)new Button((int)x, (int)(this.f_96544_ / 2 - 90 - 22), (int)w, (int)20, (Component)new TranslatableComponent((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"immersive_paintings.page.\u0001"}, (String)page.name().toLowerCase((Locale)Locale.ROOT)))), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$rebuild$3(immersive_paintings.client.gui.ImmersivePaintingScreen$Page net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((ImmersivePaintingScreen)this, (Page)page)))).f_93623_ = page != this.page;
                x += w;
            }
        }
        switch (this.page) {
            case NEW: {
                EditBox textFieldWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 90, this.f_96544_ / 2 - 38, 180, 16, (Component)new TextComponent("URL")));
                textFieldWidget.m_94199_(1024);
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ / 2 - 15, 100, 20, (Component)new TranslatableComponent("immersive_paintings.load"), sender -> this.loadImage(textFieldWidget.m_94155_())));
                this.rebuildScreenshots();
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 65, this.f_96544_ / 2 + 70, 30, 20, (Component)new TextComponent("<<"), sender -> this.setScreenshotPage(this.screenshotPage - 1)));
                this.pageWidget = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 65 + 30, this.f_96544_ / 2 + 70, 70, 20, (Component)new TextComponent(""), sender -> {}));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 65 + 100, this.f_96544_ / 2 + 70, 30, 20, (Component)new TextComponent(">>"), sender -> this.setScreenshotPage(this.screenshotPage + 1)));
                this.setScreenshotPage(this.screenshotPage);
                break;
            }
            case CREATE: {
                EditBox textFieldWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 90, this.f_96544_ / 2 - 100, 180, 20, (Component)new TranslatableComponent("immersive_paintings.name")));
                textFieldWidget.m_94199_(256);
                textFieldWidget.m_94144_(this.currentImageName);
                textFieldWidget.m_94151_(s -> {
                    this.currentImageName = s;
                });
                int y = this.f_96544_ / 2 - 60;
                this.m_142416_((GuiEventListener)new IntegerSliderWidget(this.f_96543_ / 2 - 200, y, 100, 20, "immersive_paintings.width", this.settings.width, 1, 16, v -> {
                    this.settings.width = v;
                    this.shouldReProcess = true;
                }));
                this.m_142416_((GuiEventListener)new IntegerSliderWidget(this.f_96543_ / 2 - 200, y += 22, 100, 20, "immersive_paintings.height", this.settings.height, 1, 16, v -> {
                    this.settings.height = v;
                    this.shouldReProcess = true;
                }));
                int x2 = this.f_96543_ / 2 - 200;
                TooltipButtonWidget widget = (TooltipButtonWidget)this.m_142416_((GuiEventListener)new TooltipButtonWidget(x2 + 25, y += 22, 50, 20, (Component)new TextComponent(String.valueOf(this.settings.resolution)), (Component)new TranslatableComponent("immersive_paintings.tooltip.resolution"), v -> {}));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(x2, y, 25, 20, (Component)new TextComponent("<"), (Component)new TranslatableComponent("immersive_paintings.tooltip.resolution"), v -> {
                    this.settings.resolution = Math.max(this.minResolution, this.settings.resolution / 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    widget.m_93666_((Component)new TextComponent(String.valueOf(this.settings.resolution)));
                }));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(x2 + 75, y, 25, 20, (Component)new TextComponent(">"), (Component)new TranslatableComponent("immersive_paintings.tooltip.resolution"), v -> {
                    this.settings.resolution = Math.min(this.maxResolution, this.settings.resolution * 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    widget.m_93666_((Component)new TextComponent(String.valueOf(this.settings.resolution)));
                }));
                y += 22;
                ((IntegerSliderWidget)this.m_142416_((GuiEventListener)new IntegerSliderWidget((int)(this.f_96543_ / 2 - 200), (int)(y += 10), (int)100, (int)20, (String)"immersive_paintings.colors", (double)((double)this.settings.colors), (int)1, (int)25, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$14(java.lang.Integer ), (Ljava/lang/Integer;)V)((ImmersivePaintingScreen)this)))).f_93623_ = !this.settings.pixelArt;
                ((PercentageSliderWidget)this.m_142416_((GuiEventListener)new PercentageSliderWidget((int)(this.f_96543_ / 2 - 200), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.dither", (double)this.settings.dither, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$15(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).f_93623_ = !this.settings.pixelArt;
                y = this.f_96544_ / 2 - 50;
                this.m_142416_((GuiEventListener)new CallbackCheckboxWidget(this.f_96543_ / 2 + 100, y, 20, 20, (Component)new TranslatableComponent("immersive_paintings.pixelart"), (Component)new TranslatableComponent("immersive_paintings.pixelart.tooltip"), this.settings.pixelArt, true, b -> {
                    this.settings.pixelArt = b;
                    this.adaptToPixelArt();
                    this.refreshPage();
                    this.shouldReProcess = true;
                }));
                this.m_142416_((GuiEventListener)new CallbackCheckboxWidget(this.f_96543_ / 2 + 100, y += 22, 100, 20, (Component)new TranslatableComponent("immersive_paintings.hide"), (Component)new TranslatableComponent("immersive_paintings.visibility"), this.settings.hidden, true, v -> {
                    this.settings.hidden = !this.settings.hidden;
                }));
                this.m_142416_((GuiEventListener)new PercentageSliderWidget(this.f_96543_ / 2 + 100, y += 22, 100, 20, "immersive_paintings.x_offset", this.settings.offsetX, v -> {
                    this.settings.offsetX = v;
                    this.shouldReProcess = true;
                }));
                this.m_142416_((GuiEventListener)new PercentageSliderWidget(this.f_96543_ / 2 + 100, y += 22, 100, 20, "immersive_paintings.y_offset", this.settings.offsetY, v -> {
                    this.settings.offsetY = v;
                    this.shouldReProcess = true;
                }));
                ((PercentageSliderWidget)this.m_142416_((GuiEventListener)new PercentageSliderWidget((int)(this.f_96543_ / 2 + 100), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.zoom", (double)this.settings.zoom, (double)(this.entity.isGraffiti() ? 0.5 : 1.0), (double)(this.entity.isGraffiti() ? 1.5 : 3.0), (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$20(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).f_93623_ = !this.settings.pixelArt;
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 85, this.f_96544_ / 2 + 75, 80, 20, (Component)new TranslatableComponent("immersive_paintings.cancel"), v -> this.setPage(Page.NEW)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 2 + 75, 80, 20, (Component)new TranslatableComponent("immersive_paintings.save"), v -> {
                    Utils.processByteArrayInChunks(this.pixelatedImage.encode(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new UploadPaintingRequest((byte[])ints, (int)split, (int)splits))));
                    LazyNetworkManager.sendToServer(new RegisterPaintingRequest(this.currentImageName, new Painting(this.pixelatedImage, this.settings.width, this.settings.height, this.settings.resolution, this.settings.hidden, this.entity.isGraffiti())));
                    this.setPage(Page.LOADING);
                }));
                break;
            }
            case YOURS: 
            case DATAPACKS: 
            case PLAYERS: {
                this.rebuildPaintings();
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 35 - 30, this.f_96544_ / 2 + 80, 30, 20, (Component)new TextComponent("<<"), sender -> this.setSelectionPage(this.selectionPage - 1)));
                this.pageWidget = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 35, this.f_96544_ / 2 + 80, 70, 20, (Component)new TextComponent(""), sender -> {}));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 35, this.f_96544_ / 2 + 80, 30, 20, (Component)new TextComponent(">>"), sender -> this.setSelectionPage(this.selectionPage + 1)));
                this.setSelectionPage(this.selectionPage);
                EditBox textFieldWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 88, 130, 16, (Component)new TranslatableComponent("immersive_paintings.search")));
                textFieldWidget.m_94199_(64);
                textFieldWidget.m_94167_("search");
                textFieldWidget.m_94151_(s -> {
                    this.filteredString = s;
                    this.updateSearch();
                    textFieldWidget.m_94167_(null);
                });
                x = this.f_96543_ / 2 - 200 + 12;
                Button widget = (Button)this.m_142416_((GuiEventListener)new TooltipButtonWidget(x + 50 + 8, this.f_96544_ / 2 - 90, 25, 20, (Component)new TextComponent(String.valueOf(this.filteredResolution)), (Component)new TranslatableComponent("immersive_paintings.tooltip.filter_resolution"), v -> {}));
                TooltipButtonWidget allWidget = (TooltipButtonWidget)this.m_142416_((GuiEventListener)new TooltipButtonWidget(x, this.f_96544_ / 2 - 90, 25, 20, (Component)new TranslatableComponent("immersive_paintings.filter.all"), (Component)new TranslatableComponent("immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = 0;
                    this.updateSearch();
                    widget.m_93666_((Component)new TextComponent(String.valueOf(this.filteredResolution)));
                    v.f_93623_ = false;
                }));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(x + 25 + 8, this.f_96544_ / 2 - 90, 25, 20, (Component)new TextComponent("<"), (Component)new TranslatableComponent("immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.max(this.minResolution, this.filteredResolution / 2);
                    this.updateSearch();
                    widget.m_93666_((Component)new TextComponent(String.valueOf(this.filteredResolution)));
                    allWidget.f_93623_ = true;
                }));
                this.m_142416_((GuiEventListener)new TooltipButtonWidget(x + 75 + 8, this.f_96544_ / 2 - 90, 25, 20, (Component)new TextComponent(">"), (Component)new TranslatableComponent("immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.min(this.maxResolution, this.filteredResolution * 2);
                    this.updateSearch();
                    widget.m_93666_((Component)new TextComponent(String.valueOf(this.filteredResolution)));
                    allWidget.f_93623_ = true;
                }));
                EditBox widthWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 + 80, this.f_96544_ / 2 - 88, 40, 16, (Component)new TranslatableComponent("immersive_paintings.filter_width")));
                widthWidget.m_94199_(2);
                widthWidget.m_94167_("width");
                widthWidget.m_94151_(s -> {
                    try {
                        this.filteredWidth = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredWidth = 0;
                    }
                    this.updateSearch();
                    widthWidget.m_94167_(null);
                });
                EditBox heightWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 + 80 + 40, this.f_96544_ / 2 - 88, 40, 16, (Component)new TranslatableComponent("immersive_paintings.filter_height")));
                heightWidget.m_94199_(2);
                heightWidget.m_94167_("height");
                heightWidget.m_94151_(s -> {
                    try {
                        this.filteredHeight = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredHeight = 0;
                    }
                    this.updateSearch();
                    heightWidget.m_94167_(null);
                });
                break;
            }
            case FRAME: {
                int y = this.f_96544_ / 2 - 80;
                List<ResourceLocation> frames = FrameLoader.frames.values().stream().map(Frame::frame).distinct().sorted(ResourceLocation::compareTo).toList();
                for (ResourceLocation frame : frames) {
                    Button widget = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 200, y, 100, 20, (Component)new TranslatableComponent("immersive_paintings.frame." + Utils.identifierToTranslation(frame)), v -> {
                        this.entity.setFrame(frame);
                        this.entity.setMaterial(this.getMaterialsList().get(0));
                        NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                        this.setPage(Page.FRAME);
                    }));
                    widget.f_93623_ = !frame.equals((Object)this.entity.getFrame());
                    y += 25;
                }
                int py = 0;
                int px = 0;
                List<ResourceLocation> materials = this.getMaterialsList();
                LinkedList<Button> materialList = new LinkedList<Button>();
                for (ResourceLocation material : materials) {
                    Button widget = (Button)this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 - 80 + px * 65, this.f_96544_ / 2 - 80 + py * 20, 64, 16, new ResourceLocation(material.m_135827_(), material.m_135815_().replace("/block/", "/gui/")), 0, 0, 64, 32, (Component)new TextComponent(""), v -> {
                        this.entity.setMaterial(material);
                        NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                        materialList.forEach(b -> {
                            b.f_93623_ = true;
                        });
                        v.f_93623_ = false;
                    }, (b, matrixStack, mx, my) -> this.m_96602_(matrixStack, (Component)new TranslatableComponent("immersive_paintings.material." + Utils.identifierToTranslation(material)), mx, my)));
                    widget.f_93623_ = !material.equals((Object)this.entity.getMaterial());
                    materialList.add(widget);
                    if (++px <= 3) continue;
                    px = 0;
                    ++py;
                }
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ / 2 + 70, 100, 20, (Component)new TranslatableComponent("immersive_paintings.done"), v -> this.m_7379_()));
                break;
            }
            case DELETE: {
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100 - 5, this.f_96544_ / 2 + 20, 100, 20, (Component)new TranslatableComponent("immersive_paintings.cancel"), v -> this.setPage(Page.YOURS)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 2 + 20, 100, 20, (Component)new TranslatableComponent("immersive_paintings.delete"), v -> {
                    NetworkHandler.sendToServer(new PaintingDeleteRequest(this.deletePainting));
                    this.setPage(Page.YOURS);
                }));
                break;
            }
            case ADMIN_DELETE: {
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 115, this.f_96544_ / 2 + 10, 70, 20, (Component)new TranslatableComponent("immersive_paintings.cancel"), v -> this.setPage(Page.PLAYERS)));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 40, this.f_96544_ / 2 + 10, 70, 20, (Component)new TranslatableComponent("immersive_paintings.delete"), v -> {
                    NetworkHandler.sendToServer(new PaintingDeleteRequest(this.deletePainting));
                    this.setPage(Page.PLAYERS);
                }));
                this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 35, this.f_96544_ / 2 + 10, 70, 20, (Component)new TranslatableComponent("immersive_paintings.delete_all"), v -> {
                    String author = ClientPaintingManager.getPainting((ResourceLocation)this.deletePainting).author;
                    ClientPaintingManager.getPaintings().entrySet().stream().filter(p -> Objects.equals(((Painting)p.getValue()).author, author) && !((Painting)p.getValue()).datapack).map(Map.Entry::getKey).forEach(p -> NetworkHandler.sendToServer(new PaintingDeleteRequest((ResourceLocation)p)));
                    this.setPage(Page.PLAYERS);
                }));
            }
        }
    }

    private void rebuildPaintings() {
        for (PaintingWidget w : this.paintingWidgetList) {
            this.m_169411_((GuiEventListener)w);
        }
        this.paintingWidgetList.clear();
        for (int y = 0; y < 3; ++y) {
            int i;
            for (int x = 0; x < 8 && (i = y * 8 + x + this.selectionPage * 24) >= 0 && i < this.filteredPaintings.size(); ++x) {
                ResourceLocation identifier = this.filteredPaintings.get(i);
                Painting painting = ClientPaintingManager.getPainting(identifier);
                LinkedList<Object> tooltip = new LinkedList<Object>();
                tooltip.add(new TextComponent(painting.name));
                tooltip.add(new TranslatableComponent("immersive_paintings.by_author", new Object[]{painting.author}).m_130940_(ChatFormatting.ITALIC));
                tooltip.add(new TranslatableComponent("immersive_paintings.resolution", new Object[]{painting.width, painting.height, painting.resolution}).m_130940_(ChatFormatting.ITALIC));
                if (this.page == Page.YOURS && painting.hidden) {
                    tooltip.add(new TranslatableComponent("immersive_paintings.hidden").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
                if (this.page == Page.YOURS || this.page == Page.PLAYERS && this.isOp()) {
                    tooltip.add(new TranslatableComponent("immersive_paintings.right_click_to_delete").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
                this.paintingWidgetList.add((PaintingWidget)this.m_142416_((GuiEventListener)new PaintingWidget(ClientPaintingManager.getPaintingTexture(identifier, Painting.Type.THUMBNAIL), (int)((double)(this.f_96543_ / 2) + ((double)x - 3.5) * 48.0) - 24, this.f_96544_ / 2 - 66 + y * 48, 46, 46, sender -> {
                    this.entity.setMotive(identifier);
                    NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                    if (this.entity.isGraffiti()) {
                        this.m_7379_();
                    } else {
                        this.setPage(Page.FRAME);
                    }
                }, b -> {
                    if (this.page == Page.YOURS) {
                        this.deletePainting = identifier;
                        this.setPage(Page.DELETE);
                    } else if (this.page == Page.PLAYERS && this.isOp()) {
                        this.deletePainting = identifier;
                        this.setPage(Page.ADMIN_DELETE);
                    }
                }, (b, matrices, mx, my) -> this.m_96597_(matrices, tooltip, mx, my))));
            }
        }
    }

    private void rebuildScreenshots() {
        int i;
        for (PaintingWidget w : this.paintingWidgetList) {
            this.m_169411_((GuiEventListener)w);
        }
        this.paintingWidgetList.clear();
        for (int x = 0; x < 5 && (i = x + this.screenshotPage * 5) >= 0 && i < this.screenshots.size(); ++x) {
            File file = this.screenshots.get(i);
            Painting painting = new Painting(null, 16, 16, 16, false, this.entity.isGraffiti());
            this.paintingWidgetList.add((PaintingWidget)this.m_142416_((GuiEventListener)new PaintingWidget(painting.thumbnail, this.f_96543_ / 2 + (x - 2) * 68 - 32, this.f_96544_ / 2 + 15, 64, 48, b -> {
                this.currentImage = ((PaintingWidget)b).thumbnail.image;
                if (this.currentImage != null) {
                    currentImagePixelZoomCache = -1;
                    this.currentImageName = file.getName();
                    this.settings = new PixelatorSettings(this.currentImage);
                    this.setPage(Page.CREATE);
                    this.pixelateImage();
                }
            }, b -> {}, (b, matrices, mx, my) -> this.m_96602_(matrices, (Component)new TextComponent(file.getName()), mx, my))));
            ResourceLocation identifier = Main.locate("screenshot_" + x);
            Runnable task = () -> {
                ByteImage image = this.loadImage(file.getPath(), identifier);
                if (image != null) {
                    painting.width = image.getWidth();
                    painting.height = image.getHeight();
                    painting.thumbnail.image = image;
                    painting.thumbnail.textureIdentifier = identifier;
                }
            };
            this.service.submit(task);
        }
    }

    public void setPage(Page page) {
        if (page != this.page) {
            this.clearSearch();
        }
        this.page = page;
        this.filteredResolution = page == Page.DATAPACKS ? 32 : 0;
        this.rebuild();
        if (page == Page.DATAPACKS || page == Page.PLAYERS || page == Page.YOURS) {
            this.updateSearch();
        }
    }

    private void updateSearch() {
        this.filteredPaintings.clear();
        String playerName = this.getPlayerName();
        this.filteredPaintings.addAll(ClientPaintingManager.getPaintings().entrySet().stream().filter(v -> ((Painting)v.getValue()).graffiti == this.entity.isGraffiti()).filter(v -> this.page != Page.YOURS || Objects.equals(((Painting)v.getValue()).author, playerName) && !((Painting)v.getValue()).datapack).filter(v -> this.page != Page.PLAYERS || !((Painting)v.getValue()).datapack && !((Painting)v.getValue()).hidden).filter(v -> this.page != Page.DATAPACKS || ((Painting)v.getValue()).datapack).filter(v -> ((ResourceLocation)v.getKey()).toString().contains(this.filteredString)).filter(v -> this.filteredResolution == 0 || ((Painting)v.getValue()).resolution == this.filteredResolution).filter(v -> this.filteredWidth == 0 || ((Painting)v.getValue()).width == this.filteredWidth).filter(v -> this.filteredHeight == 0 || ((Painting)v.getValue()).height == this.filteredHeight).map(Map.Entry::getKey).toList());
        this.setSelectionPage(this.selectionPage);
    }

    private String getPlayerName() {
        return Minecraft.m_91087_().f_91074_ == null ? "" : Minecraft.m_91087_().f_91074_.m_36316_().getName();
    }

    private boolean isOp() {
        return Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20310_(4);
    }

    private void setSelectionPage(int p) {
        this.selectionPage = Math.min(this.getMaxPages() - 1, Math.max(0, p));
        this.rebuildPaintings();
        this.pageWidget.m_93666_((Component)new TextComponent(this.selectionPage + 1 + " / " + this.getMaxPages()));
    }

    private int getMaxPages() {
        return (int)Math.ceil((double)this.filteredPaintings.size() / 24.0);
    }

    private void setScreenshotPage(int p) {
        int oldPage = this.screenshotPage;
        this.screenshotPage = Math.min(this.getScreenshotMaxPages() - 1, Math.max(0, p));
        if (oldPage != this.screenshotPage) {
            this.rebuildScreenshots();
        }
        this.pageWidget.m_93666_((Component)new TextComponent(this.screenshotPage + 1 + " / " + this.getScreenshotMaxPages()));
    }

    private int getScreenshotMaxPages() {
        return (int)Math.ceil((double)this.screenshots.size() / 8.0);
    }

    public void m_7400_(List<Path> paths) {
        Path path = paths.get(0);
        this.loadImage(path.toString());
    }

    private void loadImage(String path) {
        this.currentImage = this.loadImage(path, Main.locate("temp"));
        currentImagePixelZoomCache = -1;
        if (this.currentImage != null) {
            this.currentImageName = FilenameUtils.getBaseName((String)path).replaceFirst("[.][^.]+$", "");
            this.settings = new PixelatorSettings(this.currentImage);
            this.setPage(Page.CREATE);
            this.pixelateImage();
        }
    }

    private ByteImage loadImage(String path, ResourceLocation identifier) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stream != null) {
            try {
                ByteImage nativeImage = ByteImage.read(stream);
                this.preprocessImage(nativeImage);
                Minecraft.m_91087_().m_91097_().m_118495_(identifier, (AbstractTexture)new DynamicTexture(ClientUtils.byteImageToNativeImage(nativeImage)));
                stream.close();
                return nativeImage;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void preprocessImage(ByteImage image) {
        this.clearError();
        if (!this.entity.isGraffiti()) {
            byte[] bytes = image.getBytes();
            for (int i = 3; i < bytes.length; i += 4) {
                if (bytes[i] == -1) continue;
                if (this.error == null) {
                    this.setError(new TranslatableComponent("immersive_paintings.graffiti_warning"));
                }
                bytes[i] = -1;
            }
        }
    }

    private static int getCurrentImagePixelZoomCache(ByteImage currentImage) {
        if (currentImagePixelZoomCache < 0) {
            currentImagePixelZoomCache = ImageManipulations.scanForPixelArtMultiple(currentImage);
        }
        return currentImagePixelZoomCache;
    }

    private void pixelateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
        shouldUpload = true;
    }

    private void adaptToPixelArt() {
        double zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(this.currentImage);
        this.settings.width = Math.max(1, Math.min(16, (int)((double)this.currentImage.getWidth() / zoom / (double)this.settings.resolution)));
        this.settings.height = Math.max(1, Math.min(16, (int)((double)this.currentImage.getHeight() / zoom / (double)this.settings.resolution)));
    }

    public static ByteImage pixelateImage(ByteImage currentImage, PixelatorSettings settings) {
        double zoom;
        ByteImage pixelatedImage = new ByteImage(settings.resolution * settings.width, settings.resolution * settings.height);
        if (settings.pixelArt) {
            zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(currentImage);
        } else {
            float fx = (float)currentImage.getWidth() / (float)pixelatedImage.getWidth();
            float fy = (float)currentImage.getHeight() / (float)pixelatedImage.getHeight();
            zoom = (double)Math.min(fx, fy) / settings.zoom;
        }
        int ox = (int)(((double)currentImage.getWidth() - (double)pixelatedImage.getWidth() * zoom) * settings.offsetX);
        int oy = (int)(((double)currentImage.getHeight() - (double)pixelatedImage.getHeight() * zoom) * settings.offsetY);
        if (settings.pixelArt) {
            ox = ox / (int)zoom * (int)zoom;
            oy = oy / (int)zoom * (int)zoom;
        }
        ImageManipulations.resize(pixelatedImage, currentImage, zoom, ox, oy);
        if (settings.dither > 0.0 && !settings.pixelArt) {
            if (settings.colors > 1) {
                ImageManipulations.dither(pixelatedImage, settings.dither / (double)settings.colors);
            } else {
                ImageManipulations.dither(pixelatedImage, settings.dither / 16.0);
            }
        }
        if (settings.colors > 1 && !settings.pixelArt) {
            ImageManipulations.reduceColors(pixelatedImage, settings.colors);
        }
        return pixelatedImage;
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(TranslatableComponent text) {
        this.error = text;
    }

    private /* synthetic */ void lambda$rebuild$20(Double v) {
        this.settings.zoom = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$15(Double v) {
        this.settings.dither = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$14(Integer v) {
        this.settings.colors = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$3(Page page, Button sender) {
        this.setPage(page);
    }

    public static enum Page {
        YOURS,
        DATAPACKS,
        PLAYERS,
        NEW,
        CREATE,
        FRAME,
        DELETE,
        ADMIN_DELETE,
        LOADING;

    }

    public static final class PixelatorSettings {
        public double dither;
        public int colors;
        public int resolution;
        public int width;
        public int height;
        public double offsetX;
        public double offsetY;
        public double zoom;
        public boolean pixelArt;
        public boolean hidden;

        public PixelatorSettings(double dither, int colors, int resolution, int width, int height, double offsetX, double offsetY, double zoom, boolean pixelArt) {
            this.dither = dither;
            this.colors = colors;
            this.resolution = resolution;
            this.width = width;
            this.height = height;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.zoom = zoom;
            this.pixelArt = pixelArt;
        }

        PixelatorSettings(ByteImage currentImage) {
            this(0.25, 10, 32, 1, 1, 0.5, 0.5, 1.0, false);
            double target = (double)currentImage.getWidth() / (double)currentImage.getHeight();
            double bestScore = 100.0;
            double d = Math.sqrt(currentImage.getWidth() * currentImage.getWidth() + currentImage.getHeight() * currentImage.getHeight());
            double dw = (double)currentImage.getWidth() / d;
            double dh = (double)currentImage.getHeight() / d;
            float diagonal = 3.0f;
            while ((double)diagonal < 6.0) {
                int ph;
                int pw = (int)Math.ceil(dw * (double)diagonal);
                double e = Math.abs((double)pw / (double)(ph = (int)Math.ceil(dh * (double)diagonal)) - target) * Math.sqrt(5 + this.width + this.height);
                if (e < bestScore) {
                    this.width = Math.max(1, Math.min(16, pw));
                    this.height = Math.max(1, Math.min(16, ph));
                    bestScore = e;
                }
                diagonal = (float)((double)diagonal + target);
            }
        }
    }
}

