/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.cobalt.registration;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class Registration {
    private static Impl INSTANCE;

    public static <T> T register(Registry<? super T> registry, ResourceLocation id, T obj) {
        return INSTANCE.register(registry, id, obj);
    }

    public static <T extends Entity> void registerEntityRenderer(EntityType<?> type, EntityRendererProvider<T> constructor) {
        INSTANCE.registerEntityRenderer(type, constructor);
    }

    public static abstract class Impl {
        protected Impl() {
            INSTANCE = this;
        }

        public abstract <T extends Entity> void registerEntityRenderer(EntityType<T> var1, EntityRendererProvider<T> var2);

        public abstract <T> T register(Registry<? super T> var1, ResourceLocation var2, T var3);

        public abstract CreativeModeTab itemGroup(ResourceLocation var1, Supplier<ItemStack> var2);

        public abstract Supplier<SimpleParticleType> simpleParticle();

        public abstract Function<ResourceLocation, Activity> activity();

        public abstract <T extends Sensor<?>> BiFunction<ResourceLocation, Supplier<T>, SensorType<T>> sensor();

        public abstract <U> BiFunction<ResourceLocation, Optional<Codec<U>>, MemoryModuleType<U>> memoryModule();

        public abstract <T extends LivingEntity> BiFunction<EntityType<T>, Supplier<AttributeSupplier.Builder>, EntityType<T>> defaultEntityAttributes();

        public abstract ProfessionFactory<VillagerProfession> profession();
    }

    public static interface ProfessionFactory<T> {
        public T apply(ResourceLocation var1, PoiType var2, @Nullable SoundEvent var3, Iterable<Item> var4, Iterable<Block> var5);
    }

    protected static interface PoiFactory<T> {
        public T apply(ResourceLocation var1, int var2, int var3, Block ... var4);
    }

    public static class ObjectBuilders {

        public static class Profession {
            public static ProfessionFactory<VillagerProfession> creator() {
                return INSTANCE.profession();
            }
        }

        public static class Sensors {
            public static <T extends Sensor<?>> SensorType<T> create(ResourceLocation id, Supplier<T> factory) {
                return INSTANCE.sensor().apply(id, factory);
            }
        }

        public static class Activities {
            public static Activity create(ResourceLocation id) {
                return INSTANCE.activity().apply(id);
            }
        }

        public static class Particles {
            public static SimpleParticleType simpleParticle() {
                return INSTANCE.simpleParticle().get();
            }
        }

        public static class DefaultEntityAttributes {
            public static <T extends LivingEntity> EntityType<T> add(EntityType<T> type, Supplier<AttributeSupplier.Builder> attributes) {
                return INSTANCE.defaultEntityAttributes().apply(type, attributes);
            }
        }

        public static class ItemGroups {
            public static CreativeModeTab create(ResourceLocation id, Supplier<ItemStack> icon) {
                return INSTANCE.itemGroup(id, icon);
            }
        }
    }
}

