/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.compat;

import immersive_paintings.Main;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.c2s.RegisterPaintingRequest;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;

public class XercaPaintCompat {
    public static boolean interactWithPainting(ImmersivePaintingEntity painting, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ResourceLocation id = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
        if (id.m_135827_().equals("xercapaint")) {
            int w = 0;
            int h = 0;
            if (id.m_135815_().equals("item_canvas")) {
                w = 16;
                h = 16;
            } else if (id.m_135815_().equals("item_canvas_large")) {
                w = 32;
                h = 32;
            } else if (id.m_135815_().equals("item_canvas_long")) {
                w = 32;
                h = 16;
            } else if (id.m_135815_().equals("item_canvas_tall")) {
                w = 16;
                h = 32;
            }
            CompoundTag nbt = stack.m_41783_();
            if (w > 0 && nbt != null && nbt.m_128441_("pixels")) {
                int[] pixels = nbt.m_128465_("pixels");
                BufferedImage bufferedImage = new BufferedImage(w, h, 1);
                int x = 0;
                int y = 0;
                for (int n : pixels) {
                    bufferedImage.setRGB(x, y, n);
                    if (++x < w) continue;
                    x = 0;
                    ++y;
                }
                String title = nbt.m_128441_("title") ? nbt.m_128461_("title") : (nbt.m_128441_("ip_title") ? nbt.m_128461_("ip_title") : "Unnamed Painting #" + player.m_21187_().nextInt(0x100000));
                nbt.m_128359_("ip_title", title);
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", stream);
                    Utils.processByteArrayInChunks(stream.toByteArray(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new UploadPaintingRequest((byte[])ints, (int)split, (int)splits))));
                    LazyNetworkManager.sendToServer(new RegisterPaintingRequest(title, new Painting(null, w / 16, h / 16, 16, false, false)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String name = Utils.escapeString(player.m_36316_().getName()) + "/" + Utils.escapeString(title);
                ResourceLocation identifier = Main.locate(name);
                painting.setMotive(identifier);
                LazyNetworkManager.sendToServer(new PaintingModifyRequest(painting));
                return true;
            }
        }
        return false;
    }
}

