/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.entity.ImmersivePaintingEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public abstract class PaintingDataMessage
extends Message {
    final String motive;
    final String frame;
    final String material;
    final int entityId;
    private final Direction facing;
    private final int rotation;
    private final int x;
    private final int y;
    private final int z;

    public PaintingDataMessage(ImmersivePaintingEntity painting) {
        this.entityId = painting.m_142049_();
        this.motive = painting.getMotive().toString();
        this.frame = painting.getFrame().toString();
        this.material = painting.getMaterial().toString();
        this.facing = painting.m_6350_();
        this.rotation = painting.getRotation();
        this.x = painting.getAttachmentPos().m_123341_();
        this.y = painting.getAttachmentPos().m_123342_();
        this.z = painting.getAttachmentPos().m_123343_();
    }

    public PaintingDataMessage(FriendlyByteBuf b) {
        this.entityId = b.readInt();
        this.motive = b.m_130277_();
        this.frame = b.m_130277_();
        this.material = b.m_130277_();
        this.facing = (Direction)b.m_130066_(Direction.class);
        this.rotation = b.readInt();
        this.x = b.readInt();
        this.y = b.readInt();
        this.z = b.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.entityId);
        b.m_130070_(this.motive);
        b.m_130070_(this.frame);
        b.m_130070_(this.material);
        b.m_130068_((Enum)this.facing);
        b.writeInt(this.rotation);
        b.writeInt(this.x);
        b.writeInt(this.y);
        b.writeInt(this.z);
    }

    public ResourceLocation getMotive() {
        return new ResourceLocation(this.motive);
    }

    public ResourceLocation getFrame() {
        return new ResourceLocation(this.frame);
    }

    public int getRotation() {
        return this.rotation;
    }

    public ResourceLocation getMaterial() {
        return new ResourceLocation(this.material);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

