/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.resources.ByteImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;

public final class Painting {
    public int width;
    public int height;
    public final int resolution;
    public final String name;
    public final String author;
    public final boolean datapack;
    public final boolean hidden;
    public final boolean graffiti;
    public final Texture texture;
    public final Texture half;
    public final Texture quarter;
    public final Texture eighth;
    public final Texture thumbnail;
    public static final Painting DEFAULT = new Painting(new ByteImage(16, 16), 16);

    public Painting(@Nullable ByteImage image, int width, int height, int resolution, boolean hidden, boolean graffiti) {
        this(image, width, height, resolution, "", "", false, hidden, graffiti, UUID.randomUUID().toString());
    }

    public Painting(@Nullable ByteImage image, int width, int height, int resolution, String name, String author, boolean datapack, boolean hidden, boolean graffiti, String hash) {
        this.graffiti = graffiti;
        this.texture = new Texture(image, hash, Type.FULL);
        int res = Math.max(width, height) * resolution;
        Type halfType = res / 2 < Config.getInstance().lodResolutionMinimum ? Type.FULL : Type.HALF;
        this.half = new Texture(null, hash + "_half", halfType);
        Type quarterType = res / 4 < Config.getInstance().lodResolutionMinimum ? halfType : Type.QUARTER;
        this.quarter = new Texture(null, hash + "_quarter", quarterType);
        Type eighthType = res / 8 < Config.getInstance().lodResolutionMinimum ? quarterType : Type.EIGHTH;
        this.eighth = new Texture(null, hash + "_eighth", eighthType);
        Type thumbnailType = res < Config.getInstance().thumbnailSize ? Type.FULL : Type.THUMBNAIL;
        this.thumbnail = new Texture(null, hash + "_thumbnail", thumbnailType);
        this.width = width;
        this.height = height;
        this.resolution = resolution;
        this.name = name;
        this.author = author;
        this.datapack = datapack;
        this.hidden = hidden;
    }

    public Painting(ByteImage image, int resolution) {
        this(image, image.getWidth() / resolution, image.getHeight() / resolution, resolution, "", "", false, false, false, UUID.randomUUID().toString());
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("width", this.width);
        nbt.m_128405_("height", this.height);
        nbt.m_128405_("resolution", this.resolution);
        nbt.m_128359_("name", this.name);
        nbt.m_128359_("author", this.author);
        nbt.m_128379_("datapack", this.datapack);
        nbt.m_128379_("hidden", this.hidden);
        nbt.m_128379_("graffiti", this.graffiti);
        nbt.m_128359_("hash", this.texture.hash);
        return nbt;
    }

    public static Painting fromNbt(CompoundTag nbt) {
        int width = nbt.m_128451_("width");
        int height = nbt.m_128451_("height");
        int resolution = nbt.m_128451_("resolution");
        String name = nbt.m_128461_("name");
        String author = nbt.m_128461_("author");
        boolean datapack = nbt.m_128471_("datapack");
        boolean hidden = nbt.m_128471_("hidden");
        boolean graffiti = nbt.m_128471_("graffiti");
        String hash = nbt.m_128461_("hash");
        return new Painting(null, width, height, resolution, name, author, datapack, hidden, graffiti, hash);
    }

    public Texture getTexture(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.FULL -> this.texture;
            case Type.HALF -> this.half;
            case Type.QUARTER -> this.quarter;
            case Type.EIGHTH -> this.eighth;
            case Type.THUMBNAIL -> this.thumbnail;
        };
    }

    public static class Texture {
        public ByteImage image;
        public boolean requested = false;
        public ResourceLocation textureIdentifier = Main.locate("textures/block/frame/canvas.png");
        public Resource resource;
        public final String hash;
        public final Type link;
        private byte[] cache;

        public Texture(ByteImage image, String hash, Type link) {
            this.image = image;
            this.hash = hash;
            this.link = link;
        }

        public byte[] getResource() {
            if (this.cache == null) {
                try (InputStream stream = this.resource.m_6679_();){
                    this.cache = stream.readAllBytes();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cache;
        }
    }

    public static enum Type {
        FULL,
        HALF,
        QUARTER,
        EIGHTH,
        THUMBNAIL;

    }
}

