/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class PaintingsLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, Painting>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private final Gson gson = new GsonBuilder().create();
    final String dataType = "paintings";

    protected Map<ResourceLocation, Painting> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        int dataTypeLength = "paintings".length() + 1;
        for (ResourceLocation identifier : manager.m_6540_("paintings", path -> path.endsWith(".png"))) {
            String string = identifier.m_135815_();
            ResourceLocation imageIdentifier = new ResourceLocation(identifier.m_135827_(), string.substring(dataTypeLength, string.length() - FILE_SUFFIX_LENGTH));
            try {
                Painting painting;
                ResourceLocation jsonIdentifier = new ResourceLocation(identifier.m_135827_(), string.replace(".png", ".json"));
                String hash = identifier.toString().replaceAll("[^a-zA-Z\\d]", "");
                if (manager.m_7165_(jsonIdentifier)) {
                    InputStream inputStream = manager.m_142591_(jsonIdentifier).m_6679_();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    JsonObject jsonElement = Objects.requireNonNull((JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class)).getAsJsonObject();
                    int width = GsonHelper.m_13824_((JsonObject)jsonElement, (String)"width", (int)1);
                    int height = GsonHelper.m_13824_((JsonObject)jsonElement, (String)"height", (int)1);
                    int resolution = GsonHelper.m_13824_((JsonObject)jsonElement, (String)"resolution", (int)32);
                    String name = GsonHelper.m_13851_((JsonObject)jsonElement, (String)"name", (String)"unknown");
                    String author = GsonHelper.m_13851_((JsonObject)jsonElement, (String)"author", (String)"unknown");
                    boolean graffiti = GsonHelper.m_13855_((JsonObject)jsonElement, (String)"graffiti", (boolean)false);
                    painting = new Painting(null, width, height, resolution, name, author, true, false, graffiti, hash);
                } else {
                    painting = new Painting(null, 1, 1, 32, "unknown", "unknown", true, false, false, hash);
                }
                painting.texture.resource = manager.m_142591_(identifier);
                map.put(identifier, painting);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load painting {} from {} ({})", new Object[]{imageIdentifier, identifier, exception});
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, Painting> prepared, ResourceManager manager, ProfilerFiller profiler) {
        ServerPaintingManager.setDatapackPaintings(prepared);
    }
}

