/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xerca.xercapaint.client.EaselModel;
import xerca.xercapaint.client.GuiCanvasEdit;
import xerca.xercapaint.client.GuiCanvasView;
import xerca.xercapaint.client.GuiPalette;
import xerca.xercapaint.client.RenderEntityCanvas;
import xerca.xercapaint.client.RenderEntityEasel;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;

public class ClientStuff {
    public static final ModelLayerLocation EASEL_MAIN_LAYER = new ModelLayerLocation(new ResourceLocation("xercapaint", "easel"), "main");
    public static final ModelLayerLocation EASEL_CANVAS_LAYER = new ModelLayerLocation(new ResourceLocation("xercapaint", "easel"), "canvas");

    public static void showCanvasGui(EntityEasel easel, ItemStack palette) {
        ClientStuff.showCanvasGui(easel, palette, Minecraft.m_91087_());
    }

    public static void showCanvasGui(EntityEasel easel, ItemStack palette, Minecraft minecraft) {
        ItemStack canvas = easel.getItem();
        CompoundTag tag = canvas.m_41783_();
        if (tag != null && tag.m_128451_("generation") > 0 || palette.m_41619_()) {
            minecraft.m_91152_((Screen)new GuiCanvasView(canvas.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_canvas"), ((ItemCanvas)canvas.m_41720_()).getCanvasType(), easel));
        } else {
            minecraft.m_91152_((Screen)new GuiCanvasEdit((Player)minecraft.f_91074_, canvas.m_41783_(), palette.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_canvas"), ((ItemCanvas)canvas.m_41720_()).getCanvasType(), easel));
        }
    }

    public static void showCanvasGui(Player player) {
        ItemStack heldItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (heldItem.m_41619_() || minecraft.f_91074_ != null && !minecraft.f_91074_.m_36316_().getId().equals(player.m_36316_().getId())) {
            return;
        }
        if (heldItem.m_41720_() instanceof ItemCanvas) {
            CompoundTag tag = heldItem.m_41783_();
            if (offhandItem.m_41619_() || !(offhandItem.m_41720_() instanceof ItemPalette) || tag != null && tag.m_128451_("generation") > 0) {
                minecraft.m_91152_((Screen)new GuiCanvasView(heldItem.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_canvas"), ((ItemCanvas)heldItem.m_41720_()).getCanvasType(), null));
            } else {
                minecraft.m_91152_((Screen)new GuiCanvasEdit((Player)minecraft.f_91074_, tag, offhandItem.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_canvas"), ((ItemCanvas)heldItem.m_41720_()).getCanvasType(), null));
            }
        } else if (heldItem.m_41720_() instanceof ItemPalette) {
            if (offhandItem.m_41619_() || !(offhandItem.m_41720_() instanceof ItemCanvas)) {
                minecraft.m_91152_((Screen)new GuiPalette(heldItem.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_palette")));
            } else {
                CompoundTag tag = offhandItem.m_41783_();
                if (tag != null && tag.m_128451_("generation") > 0) {
                    minecraft.m_91152_((Screen)new GuiCanvasView(offhandItem.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_canvas"), ((ItemCanvas)offhandItem.m_41720_()).getCanvasType(), null));
                } else {
                    minecraft.m_91152_((Screen)new GuiCanvasEdit((Player)minecraft.f_91074_, tag, heldItem.m_41783_(), (Component)new TranslatableComponent("item.xercapaint.item_canvas"), ((ItemCanvas)offhandItem.m_41720_()).getCanvasType(), null));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="xercapaint", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusSubscriber {
        @SubscribeEvent
        public static void clientSetupHandler(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemPropertyFunction drawn = (itemStack, level, livingEntity, i) -> {
                    if (!itemStack.m_41782_()) {
                        return 0.0f;
                    }
                    return 1.0f;
                };
                ItemPropertyFunction colors = (stack, worldIn, entityIn, i) -> (float)ItemPalette.basicColorCount(stack) / 16.0f;
                ItemProperties.register((Item)Objects.requireNonNull(Items.ITEM_CANVAS), (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (ItemPropertyFunction)drawn);
                ItemProperties.register((Item)Objects.requireNonNull(Items.ITEM_CANVAS_LARGE), (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (ItemPropertyFunction)drawn);
                ItemProperties.register((Item)Objects.requireNonNull(Items.ITEM_CANVAS_LONG), (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (ItemPropertyFunction)drawn);
                ItemProperties.register((Item)Objects.requireNonNull(Items.ITEM_CANVAS_TALL), (ResourceLocation)new ResourceLocation("xercapaint", "drawn"), (ItemPropertyFunction)drawn);
                ItemProperties.register((Item)Objects.requireNonNull(Items.ITEM_PALETTE), (ResourceLocation)new ResourceLocation("xercapaint", "colors"), (ItemPropertyFunction)colors);
            });
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(Entities.CANVAS, (EntityRendererProvider)new RenderEntityCanvas.RenderEntityCanvasFactory());
            event.registerEntityRenderer(Entities.EASEL, (EntityRendererProvider)new RenderEntityEasel.RenderEntityEaselFactory());
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(EASEL_MAIN_LAYER, EaselModel::createBodyLayer);
            event.registerLayerDefinition(EASEL_CANVAS_LAYER, EaselModel::createBodyLayer);
        }
    }
}

