/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.PictureRequestPacket;

public class EntityCanvas
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private String canvasName;
    private String canvasTitle;
    private String canvasAuthor;
    private int canvasVersion;
    private int canvasGeneration = 0;
    private boolean canvasSigned;
    private int tickCounter1 = 0;
    private CanvasType canvasType;
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.m_135353_(EntityCanvas.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<String, Picture> PICTURES = Maps.newHashMap();
    public static final Set<String> PICTURE_REQUESTS = Sets.newHashSet();

    public EntityCanvas(Level world, CompoundTag canvasNBT, BlockPos pos, Direction facing, CanvasType canvasType, int rotation) {
        super(Objects.requireNonNull(Entities.CANVAS), world, pos);
        this.canvasName = canvasNBT.m_128461_("name");
        this.canvasVersion = canvasNBT.m_128451_("v");
        if (canvasNBT.m_128441_("title") && canvasNBT.m_128441_("author")) {
            this.canvasSigned = true;
            this.canvasTitle = canvasNBT.m_128461_("title");
            this.canvasAuthor = canvasNBT.m_128461_("author");
            this.canvasGeneration = canvasNBT.m_128451_("generation");
        } else {
            this.canvasSigned = false;
        }
        this.canvasType = canvasType;
        this.setRotation(rotation);
        this.m_6022_(facing);
        Picture picture = PICTURES.get(this.canvasName);
        if (picture == null || picture.version < this.canvasVersion) {
            PICTURES.put(this.canvasName, new Picture(this.canvasVersion, canvasNBT.m_128465_("pixels")));
        }
    }

    public EntityCanvas(EntityType<EntityCanvas> entityCanvasEntityType, Level world) {
        super(entityCanvasEntityType, world);
    }

    public EntityCanvas(PlayMessages.SpawnEntity ignoredSpawnEntity, Level world) {
        super(Objects.requireNonNull(Entities.CANVAS), world);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ROTATION, (Object)0);
    }

    public int m_7076_() {
        return CanvasType.getWidth(this.canvasType);
    }

    public int m_7068_() {
        return CanvasType.getHeight(this.canvasType);
    }

    protected float m_6380_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 0.0f;
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public int getCanvasVersion() {
        return this.canvasVersion;
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            Picture picture;
            ItemStack canvasItem;
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (brokenEntity instanceof Player) {
                Player player = (Player)brokenEntity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            if (this.canvasType == CanvasType.SMALL) {
                canvasItem = new ItemStack((ItemLike)Items.ITEM_CANVAS);
            } else if (this.canvasType == CanvasType.LARGE) {
                canvasItem = new ItemStack((ItemLike)Items.ITEM_CANVAS_LARGE);
            } else if (this.canvasType == CanvasType.LONG) {
                canvasItem = new ItemStack((ItemLike)Items.ITEM_CANVAS_LONG);
            } else if (this.canvasType == CanvasType.TALL) {
                canvasItem = new ItemStack((ItemLike)Items.ITEM_CANVAS_TALL);
            } else {
                XercaPaint.LOGGER.error("Invalid canvas type");
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("name", this.canvasName);
            nbt.m_128405_("v", this.canvasVersion);
            nbt.m_128405_("generation", 0);
            if (this.canvasSigned) {
                nbt.m_128359_("author", this.canvasAuthor);
                nbt.m_128359_("title", this.canvasTitle);
                nbt.m_128405_("generation", this.canvasGeneration);
            }
            if ((picture = PICTURES.get(this.canvasName)) != null) {
                nbt.m_128385_("pixels", picture.pixels);
            }
            canvasItem.m_41751_(nbt);
            this.m_19983_(canvasItem);
        }
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.tickCounter1++ == 50 && !this.f_19853_.f_46443_) {
            this.tickCounter1 = 0;
            if (this.m_6084_() && !this.m_7088_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_5553_(null);
            }
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    protected void m_6022_(@NotNull Direction facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.f_31699_ = facingDirectionIn;
        if (facingDirectionIn.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * facingDirectionIn.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    private double offs(int l) {
        return l % 32 == 0 ? 0.5 : 0.0;
    }

    protected void m_7087_() {
        if (this.canvasType != null) {
            double d1 = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * 0.46875;
            double d2 = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * 0.46875;
            double d3 = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * 0.46875;
            if (this.f_31699_.m_122434_().m_122479_()) {
                double d4 = this.offs(this.m_7076_());
                double d5 = this.offs(this.m_7068_());
                d2 += d5;
                Direction direction = this.f_31699_.m_122428_();
                d1 += d4 * (double)direction.m_122429_();
                d3 += d4 * (double)direction.m_122431_();
            }
            this.m_20343_(d1, d2, d3);
            double d6 = this.m_7076_() - 2;
            double d7 = this.m_7068_() - 2;
            double d8 = this.m_7076_() - 2;
            Direction.Axis direction$axis = this.f_31699_.m_122434_();
            switch (direction$axis) {
                case X: {
                    d6 = 1.0;
                    break;
                }
                case Y: {
                    d7 = 1.0;
                    break;
                }
                case Z: {
                    d8 = 1.0;
                }
            }
            this.m_20011_(new AABB(d1 - (d6 /= 32.0), d2 - (d7 /= 32.0), d3 - (d8 /= 32.0), d1 + d6, d2 + d7, d3 + d8));
        }
    }

    public boolean m_7088_() {
        if (this.f_31699_.m_122434_().m_122479_()) {
            return super.m_7088_();
        }
        if (!this.f_19853_.m_45786_((Entity)this)) {
            return false;
        }
        BlockState blockstate = this.f_19853_.m_8055_(this.f_31698_.m_142300_(this.f_31699_.m_122424_()));
        return (blockstate.m_60767_().m_76333_() || this.f_31699_.m_122434_().m_122479_() && DiodeBlock.m_52586_((BlockState)blockstate)) && this.f_19853_.m_6249_((Entity)this, this.m_142469_(), f_31697_).isEmpty();
    }

    public int getRotation() {
        return (Integer)this.m_20088_().m_135370_(ROTATION);
    }

    private void setRotation(int rotation) {
        this.m_20088_().m_135381_(ROTATION, (Object)(rotation % 4));
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7378_(CompoundTag tagCompound) {
        Picture picture;
        this.f_31698_ = new BlockPos(tagCompound.m_128451_("TileX"), tagCompound.m_128451_("TileY"), tagCompound.m_128451_("TileZ"));
        CompoundTag canvasNBT = tagCompound;
        if (tagCompound.m_128441_("canvas")) {
            canvasNBT = tagCompound.m_128469_("canvas");
        }
        this.canvasSigned = canvasNBT.m_128441_("author") && canvasNBT.m_128441_("title");
        this.canvasName = canvasNBT.m_128461_("name");
        this.canvasVersion = canvasNBT.m_128451_("v");
        if (this.canvasSigned) {
            this.canvasAuthor = canvasNBT.m_128461_("author");
            this.canvasTitle = canvasNBT.m_128461_("title");
            this.canvasGeneration = canvasNBT.m_128451_("generation");
        }
        if ((picture = PICTURES.get(this.canvasName)) == null || picture.version < this.canvasVersion) {
            PICTURES.put(this.canvasName, new Picture(this.canvasVersion, canvasNBT.m_128465_("pixels")));
        }
        this.canvasType = CanvasType.fromByte(tagCompound.m_128445_("ctype"));
        if (tagCompound.m_128441_("Facing") && !tagCompound.m_128441_("RealFace")) {
            byte facing = tagCompound.m_128445_("Facing");
            Direction horizontal = Direction.m_122407_((int)facing);
            this.m_6022_(horizontal);
        } else {
            this.m_6022_(Direction.m_122376_((int)tagCompound.m_128445_("RealFace")));
        }
        this.setRotation(tagCompound.m_128445_("Rotation"));
    }

    public void m_7380_(CompoundTag tagCompound) {
        BlockPos blockpos = this.m_31748_();
        tagCompound.m_128405_("TileX", blockpos.m_123341_());
        tagCompound.m_128405_("TileY", blockpos.m_123342_());
        tagCompound.m_128405_("TileZ", blockpos.m_123343_());
        tagCompound.m_128359_("name", this.canvasName);
        tagCompound.m_128405_("v", this.canvasVersion);
        if (this.canvasSigned) {
            tagCompound.m_128359_("author", this.canvasAuthor);
            tagCompound.m_128359_("title", this.canvasTitle);
            tagCompound.m_128405_("generation", this.canvasGeneration);
        }
        tagCompound.m_128344_("ctype", (byte)this.canvasType.ordinal());
        tagCompound.m_128344_("RealFace", (byte)this.f_31699_.m_122411_());
        tagCompound.m_128344_("Rotation", (byte)this.getRotation());
        Picture picture = PICTURES.get(this.canvasName);
        if (picture != null) {
            tagCompound.m_128385_("pixels", picture.pixels);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.canvasName);
        buffer.writeInt(this.canvasVersion);
        buffer.writeInt(this.f_31699_.m_122411_());
        buffer.writeByte(this.canvasType.ordinal());
        buffer.m_130064_(this.f_31698_);
        buffer.writeByte((int)((byte)this.getRotation()));
    }

    private void requestPicture() {
        if (!PICTURE_REQUESTS.contains(this.canvasName)) {
            PICTURE_REQUESTS.add(this.canvasName);
            PictureRequestPacket pack = new PictureRequestPacket(this.canvasName);
            XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.canvasName = buffer.m_130277_();
        this.canvasVersion = buffer.readInt();
        Picture picture = PICTURES.get(this.canvasName);
        if (picture == null || picture.version < this.canvasVersion) {
            this.requestPicture();
        }
        this.f_31699_ = Direction.m_122376_((int)buffer.readInt());
        this.canvasType = CanvasType.fromByte(buffer.readByte());
        this.f_31698_ = buffer.m_130135_();
        this.setRotation(buffer.readByte());
        this.m_6022_(this.f_31699_);
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.canvasType == CanvasType.SMALL || this.canvasType == CanvasType.LARGE) {
            if (!this.f_19853_.f_46443_) {
                this.setRotation(this.getRotation() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class Picture {
        public final int version;
        public final int[] pixels;

        public Picture(int version, int[] pixels) {
            this.version = version;
            this.pixels = pixels;
        }
    }
}

