/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import java.util.Objects;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.Items;

@MethodsReturnNonnullByDefault
public class RecipeCanvasCloning
extends CustomRecipe {
    public RecipeCanvasCloning(ResourceLocation p_i48170_1_) {
        super(p_i48170_1_);
    }

    public boolean matches(CraftingContainer inv, @NotNull Level worldIn) {
        ItemStack orgCanvas = ItemStack.f_41583_;
        ItemStack freshCanvas = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack stack = inv.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemCanvas && stack.m_41782_() && WrittenBookItem.m_43473_((ItemStack)stack) > 0) {
                if (!orgCanvas.m_41619_()) {
                    return false;
                }
                if (!freshCanvas.m_41619_() && !((ItemCanvas)freshCanvas.m_41720_()).getCanvasType().equals((Object)((ItemCanvas)stack.m_41720_()).getCanvasType())) {
                    return false;
                }
                orgCanvas = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof ItemCanvas) || stack.m_41782_()) continue;
            if (!freshCanvas.m_41619_()) {
                return false;
            }
            if (!orgCanvas.m_41619_() && !((ItemCanvas)orgCanvas.m_41720_()).getCanvasType().equals((Object)((ItemCanvas)stack.m_41720_()).getCanvasType())) {
                return false;
            }
            freshCanvas = stack;
        }
        return !orgCanvas.m_41619_() && !freshCanvas.m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack orgCanvas = ItemStack.f_41583_;
        ItemStack freshCanvas = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack stack = inv.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemCanvas && stack.m_41782_() && WrittenBookItem.m_43473_((ItemStack)stack) > 0) {
                if (!orgCanvas.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                if (!freshCanvas.m_41619_() && !((ItemCanvas)freshCanvas.m_41720_()).getCanvasType().equals((Object)((ItemCanvas)stack.m_41720_()).getCanvasType())) {
                    return ItemStack.f_41583_;
                }
                orgCanvas = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof ItemCanvas) || stack.m_41782_()) continue;
            if (!freshCanvas.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!orgCanvas.m_41619_() && !((ItemCanvas)orgCanvas.m_41720_()).getCanvasType().equals((Object)((ItemCanvas)stack.m_41720_()).getCanvasType())) {
                return ItemStack.f_41583_;
            }
            freshCanvas = stack;
        }
        int gen = WrittenBookItem.m_43473_((ItemStack)orgCanvas);
        if (!orgCanvas.m_41619_() && orgCanvas.m_41782_() && orgCanvas.m_41783_() != null && !freshCanvas.m_41619_() && !freshCanvas.m_41782_() && gen < 3 && gen > 0) {
            ItemStack resultStack = new ItemStack((ItemLike)orgCanvas.m_41720_());
            CompoundTag compoundTag = orgCanvas.m_41783_().m_6426_();
            compoundTag.m_128405_("generation", gen + 1);
            resultStack.m_41751_(compoundTag);
            return resultStack;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList stacks = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.hasContainerItem()) {
                stacks.set(i, (Object)itemstack.getContainerItem());
                continue;
            }
            if (!(itemstack.m_41720_() instanceof ItemCanvas) || !itemstack.m_41782_() || WrittenBookItem.m_43473_((ItemStack)itemstack) <= 0) continue;
            ItemStack stack = itemstack.m_41777_();
            stack.m_41764_(1);
            stacks.set(i, (Object)stack);
            break;
        }
        return stacks;
    }

    public RecipeSerializer<?> m_7707_() {
        return Objects.requireNonNull(Items.CRAFTING_SPECIAL_CANVAS_CLONING);
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }
}

