/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xerca.xercapaint.common.item.Items;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeCraftPalette
extends CustomRecipe {
    private static final ResourceLocation plank = new ResourceLocation("minecraft:planks");

    public RecipeCraftPalette(ResourceLocation p_i48170_1_) {
        super(p_i48170_1_);
    }

    private boolean isPlank(ItemStack stack) {
        return stack.m_204131_().anyMatch(p -> p.f_203868_().equals((Object)plank));
    }

    private boolean isDye(ItemStack stack) {
        return stack.m_41720_() instanceof DyeItem;
    }

    private boolean isPlankRow(CraftingContainer inv, int row) {
        int plankCount = 0;
        for (int j = 0; j < inv.m_39347_(); ++j) {
            int id = row * inv.m_39347_() + j;
            ItemStack stack = inv.m_8020_(id);
            if (!this.isPlank(stack)) continue;
            ++plankCount;
        }
        return plankCount == 3;
    }

    private int findPlankRow(CraftingContainer inv) {
        for (int i = 0; i < inv.m_39346_(); ++i) {
            if (!this.isPlankRow(inv, i)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<ItemStack> findDyes(CraftingContainer inv, int plankRow) {
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_39346_(); ++i) {
            if (i == plankRow) continue;
            for (int j = 0; j < inv.m_39347_(); ++j) {
                int id = i * inv.m_39347_() + j;
                ItemStack stack = inv.m_8020_(id);
                if (this.isDye(stack)) {
                    dyes.add(stack);
                    continue;
                }
                if (stack.m_41619_()) continue;
                return null;
            }
        }
        return dyes;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return false;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, plankRow);
        return dyes != null && !dyes.isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return ItemStack.f_41583_;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, plankRow);
        if (dyes == null || dyes.isEmpty()) {
            return ItemStack.f_41583_;
        }
        byte[] basicColors = new byte[16];
        for (ItemStack dye : dyes) {
            DyeColor color = ((DyeItem)dye.m_41720_()).m_41089_();
            basicColors[15 - color.m_41060_()] = 1;
        }
        ItemStack result = new ItemStack((ItemLike)Items.ITEM_PALETTE);
        CompoundTag tag = result.m_41784_();
        tag.m_128382_("basic", basicColors);
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return Objects.requireNonNull(Items.CRAFTING_SPECIAL_PALETTE_CRAFTING);
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

