/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

public class CanvasUpdatePacketHandler {
    public static void handle(CanvasUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> CanvasUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processMessage(CanvasUpdatePacket msg, ServerPlayer pl) {
        ItemStack palette;
        ItemStack canvas;
        Entity entityEasel = null;
        if (msg.getEaselId() > -1) {
            entityEasel = pl.f_19853_.m_6815_(msg.getEaselId());
            if (entityEasel == null) {
                XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Easel entity not found! easelId: " + msg.getEaselId());
                return;
            }
            if (!(entityEasel instanceof EntityEasel)) {
                XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Entity found is not an easel! easelId: " + msg.getEaselId());
                return;
            }
            EntityEasel easel = (EntityEasel)entityEasel;
            canvas = easel.getItem();
            if (!(canvas.m_41720_() instanceof ItemCanvas)) {
                XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Canvas not found inside easel!");
                return;
            }
            ItemStack mainHandItem = pl.m_21205_();
            ItemStack offHandItem = pl.m_21206_();
            if (mainHandItem.m_41720_() instanceof ItemPalette) {
                palette = mainHandItem;
            } else {
                if (!(offHandItem.m_41720_() instanceof ItemPalette)) {
                    XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Palette not found on player's hands!");
                    return;
                }
                palette = offHandItem;
            }
        } else {
            canvas = pl.m_21205_();
            palette = pl.m_21206_();
            if (canvas.m_41720_() instanceof ItemPalette) {
                ItemStack temp = canvas;
                canvas = palette;
                palette = temp;
            }
        }
        if (!canvas.m_41619_() && canvas.m_41720_() instanceof ItemCanvas) {
            CompoundTag comp = canvas.m_41784_();
            comp.m_128385_("pixels", msg.getPixels());
            comp.m_128359_("name", msg.getName());
            comp.m_128405_("v", msg.getVersion());
            comp.m_128405_("generation", 0);
            if (msg.getSigned()) {
                comp.m_128359_("author", pl.m_7755_().getString());
                comp.m_128359_("title", msg.getTitle().trim());
                comp.m_128405_("generation", 1);
            }
            if (!palette.m_41619_() && palette.m_41720_() == Items.ITEM_PALETTE) {
                CompoundTag paletteComp = palette.m_41784_();
                PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
            }
            if (entityEasel instanceof EntityEasel) {
                EntityEasel easel = (EntityEasel)entityEasel;
                easel.setItem(canvas, false);
                easel.setPainter(null);
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

