/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.packets.ImportPaintingPacket;
import xerca.xercapaint.common.packets.ImportPaintingSendPacket;

public class ImportPaintingPacketHandler {
    public static void handle(ImportPaintingPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> ImportPaintingPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(ImportPaintingPacket msg) {
        block2: {
            String filename = msg.getName() + ".paint";
            String filepath = "paintings/" + filename;
            try {
                CompoundTag tag = NbtIo.m_128953_((File)new File(filepath));
                ImportPaintingSendPacket pack = new ImportPaintingSendPacket(tag);
                XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
            }
            catch (IOException e) {
                e.printStackTrace();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) break block2;
                player.m_6352_((Component)new TranslatableComponent("import.fail.4", new Object[]{filepath}).m_130940_(ChatFormatting.RED), Util.f_137441_);
            }
        }
    }
}

