/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.PaletteUpdatePacket;

public class PaletteUpdatePacketHandler {
    public static void handle(PaletteUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayer sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when PaletteUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> PaletteUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(PaletteUpdatePacket msg, ServerPlayer pl) {
        ItemStack palette = pl.m_21205_();
        if ((palette.m_41619_() || palette.m_41720_() != Items.ITEM_PALETTE) && ((palette = pl.m_21206_()).m_41619_() || palette.m_41720_() != Items.ITEM_PALETTE)) {
            return;
        }
        CompoundTag paletteComp = palette.m_41784_();
        PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
    }
}

