/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.customcompanions;

import com.radimous.customcompanions.Config;
import com.radimous.customcompanions.CustomCompanions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class RemoteNames {
    private static final Pattern USERNAME_PATTERN = Pattern.compile("[0-9a-zA-Z_]+", 2);
    private static List<String> remoteNames = new ArrayList<String>();

    public static List<String> getRemoteNames() {
        return Collections.unmodifiableList(remoteNames);
    }

    public static void removeRemoteNames() {
        remoteNames.clear();
    }

    public static boolean reloadRemoteNames() throws IOException {
        boolean invalidUsername = false;
        ArrayList<String> names = new ArrayList<String>();
        URL url = new URL((String)Config.NAME_URL.get());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                String name = line.trim();
                if (name.length() > 32 || !USERNAME_PATTERN.matcher(name).matches()) {
                    invalidUsername = true;
                    continue;
                }
                names.add(line.trim());
            }
        }
        remoteNames = names;
        CustomCompanions.logger.info("Fetched " + remoteNames.size() + " skins from url");
        return invalidUsername;
    }
}

