/*
 * Decompiled with CFR 0.152.
 */
package com.vincentmet.voidworld;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.vincentmet.voidworld.Config;
import com.vincentmet.voidworld.EmptyWorldChunkGen;
import com.vincentmet.voidworld.PacketHandler;
import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="voidworld")
public class BaseClass {
    public static final String MODID = "voidworld";
    public static final Path PATH_CONFIG = FMLPaths.CONFIGDIR.get().resolve("voidworld");

    public BaseClass() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupCommon);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> (Codec)Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)new ResourceLocation(MODID, MODID), EmptyWorldChunkGen.CODEC));
        Config.readConfigToMemory(PATH_CONFIG, "config.json");
        PacketHandler.init();
    }

    private void serverStopping(ServerStoppingEvent event) {
        Config.writeConfigToDisk(PATH_CONFIG, "config.json");
    }

    public static class EmptyWorldType
    extends ForgeWorldPreset {
        public EmptyWorldType() {
            super((registryAccess, seed, generatorSettings) -> new EmptyWorldChunkGen((Registry<StructureSet>)registryAccess.m_175515_(Registry.f_211073_), (BiomeSource)new FixedBiomeSource(registryAccess.m_175515_(Registry.f_122885_).m_203538_(Biomes.f_48202_))));
            this.setRegistryName(new ResourceLocation(BaseClass.MODID, BaseClass.MODID));
        }

        public String getTranslationKey() {
            return "voidworld.empty_world_type";
        }
    }

    @Mod.EventBusSubscriber(modid="voidworld", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventHandler {
        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            LevelAccessor levelAccessor = event.getWorld();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)levelAccessor;
                if (event.getWorld().m_6042_().m_63969_().equals((Object)DimensionType.f_63840_)) {
                    try {
                        ParseResults pr = serverWorld.m_142572_().m_129892_().m_82094_().parse("gamerule spawnRadius 0", (Object)serverWorld.m_142572_().m_129893_().m_81324_());
                        serverWorld.m_142572_().m_129892_().m_82094_().execute(pr);
                    }
                    catch (CommandSyntaxException commandSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            ServerPlayer player;
            Player player2 = event.getPlayer();
            if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12989_)) == 0) {
                BlockPos pos = player.m_142538_().m_6625_(1);
                for (int x = -Config.SidedConfig.getSpawnBlockRadius(); x <= Config.SidedConfig.getSpawnBlockRadius(); ++x) {
                    for (int z = -Config.SidedConfig.getSpawnBlockRadius(); z <= Config.SidedConfig.getSpawnBlockRadius(); ++z) {
                        if (!player.m_183503_().m_8055_(pos.m_142082_(x, 0, z)).m_60734_().equals(Blocks.f_50016_)) continue;
                        player.m_183503_().m_7731_(pos.m_142082_(x, 0, z), Config.SidedConfig.getSpawnBlock().m_49966_(), 2);
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="voidworld", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventHandler {
        @SubscribeEvent
        public static void registerWorldType(RegistryEvent.Register<ForgeWorldPreset> event) {
            event.getRegistry().register((IForgeRegistryEntry)new EmptyWorldType());
        }
    }
}

