/*
 * Decompiled with CFR 0.152.
 */
package com.vincentmet.voidworld;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;

public class Config {
    public static void processJson(JsonObject json) {
        JsonPrimitive jsonPrimitive;
        JsonElement jsonElement;
        if (json.has("spawn_block") && (jsonElement = json.get("spawn_block")).isJsonPrimitive() && (jsonPrimitive = jsonElement.getAsJsonPrimitive()).isString()) {
            Config.setSpawnBlock(ResourceLocation.m_135820_((String)jsonPrimitive.getAsString()));
        }
        if (json.has("spawn_block_radius") && (jsonElement = json.get("spawn_block_radius")).isJsonPrimitive() && (jsonPrimitive = jsonElement.getAsJsonPrimitive()).isNumber()) {
            Config.setSpawnBlockRadius(jsonPrimitive.getAsNumber().intValue());
        }
    }

    public static void setSpawnBlock(ResourceLocation resourceLocation) {
        ServerConfig.SPAWN_BLOCK = resourceLocation != null ? (ForgeRegistries.BLOCKS.containsKey(resourceLocation) ? (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation) : Blocks.f_50440_) : Blocks.f_50440_;
    }

    public static void setSpawnBlockRadius(int spawnBlockRadius) {
        ServerConfig.SPAWN_BLOCK_RADIUS = Math.max(spawnBlockRadius, 0);
    }

    public static JsonObject getJson() {
        JsonObject json = new JsonObject();
        json.addProperty("spawn_block", ServerConfig.SPAWN_BLOCK.getRegistryName().toString());
        json.addProperty("spawn_block_radius", (Number)ServerConfig.SPAWN_BLOCK_RADIUS);
        return json;
    }

    public static void readConfigToMemory(Path path, String file) {
        Config.processJson(Config.loadConfig(path, file));
        Config.writeConfigToDisk(path, file);
    }

    public static void writeConfigToDisk(Path path, String file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String out = gson.toJson((JsonElement)Config.getJson());
        Config.writeTo(path, file, out);
    }

    private static JsonObject loadConfig(Path path, String filename) {
        try {
            StringBuilder res = new StringBuilder();
            Files.readAllLines(path.resolve(filename), StandardCharsets.UTF_8).forEach(res::append);
            return JsonParser.parseString((String)res.toString()).getAsJsonObject();
        }
        catch (IOException e) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String out = gson.toJson((JsonElement)new JsonObject());
            Config.writeTo(path, filename, out);
            return Config.loadConfig(path, filename);
        }
    }

    private static void writeTo(Path location, String filename, Object text) {
        try {
            if (!location.toFile().exists()) {
                location.toFile().mkdirs();
            }
            Files.write(location.resolve(filename), text.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ServerConfig {
        public static Block SPAWN_BLOCK = Blocks.f_50440_;
        public static int SPAWN_BLOCK_RADIUS = 0;
    }

    public static class SidedConfig {
        public static Block getSpawnBlock() {
            return EffectiveSide.get().isClient() ? ServerToClientSyncedConfig.SPAWN_BLOCK : ServerConfig.SPAWN_BLOCK;
        }

        public static int getSpawnBlockRadius() {
            return EffectiveSide.get().isClient() ? ServerToClientSyncedConfig.SPAWN_BLOCK_RADIUS : ServerConfig.SPAWN_BLOCK_RADIUS;
        }
    }

    public static class ServerToClientSyncedConfig {
        public static Block SPAWN_BLOCK = Blocks.f_50440_;
        public static int SPAWN_BLOCK_RADIUS = 0;
    }
}

