/*
 * Decompiled with CFR 0.152.
 */
package com.mars.laserbridges;

import com.mars.laserbridges.CommonClass;
import com.mars.laserbridges.Constants;
import com.mars.laserbridges.blocks.BridgeSourceBlock;
import com.mars.laserbridges.blocks.FenceSourceBlock;
import com.mars.laserbridges.blocks.LaserBridgeBlock;
import com.mars.laserbridges.blocks.LaserFenceBlock;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="laserbridges")
public class LaserBridges {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"laserbridges");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"laserbridges");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"laserbridges");
    public static final RegistryObject<Block> BRIDGE_SOURCE_BLOCK = BLOCKS.register("laser_source_block", () -> new BridgeSourceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(0.8f).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? Constants.LIGHT : 0)));
    public static final RegistryObject<BlockItem> BRIDGE_SOURCE_BLOCK_ITEM = ITEMS.register("laser_source_block", () -> new BlockItem((Block)BRIDGE_SOURCE_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
    public static final RegistryObject<Block> LASER_BLOCK = BLOCKS.register("laser_block_powered", () -> new LaserBridgeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(-1.0f, 3600000.0f).m_60955_().m_60953_(p_220871_ -> Constants.LIGHT)));
    public static final RegistryObject<Block> LASER_FENCE_SOURCE_BLOCK = BLOCKS.register("laser_fence_source_block", () -> new FenceSourceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(0.8f).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? Constants.LIGHT : 0)));
    public static final RegistryObject<BlockItem> LASER_FENCE_SOURCE_BLOCK_ITEM = ITEMS.register("laser_fence_source_block", () -> new BlockItem((Block)LASER_FENCE_SOURCE_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
    public static final RegistryObject<Block> LASER_FENCE_BLOCK = BLOCKS.register("laser_fence_powered", () -> new LaserFenceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(-1.0f, 3600000.0f).m_60955_().m_60953_(p_220871_ -> Constants.LIGHT)));
    public static final RegistryObject<SoundEvent> ON = LaserBridges.registerSoundEvent("on");
    public static final RegistryObject<SoundEvent> OFF = LaserBridges.registerSoundEvent("off");

    public LaserBridges() {
        CommonClass.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        modEventBus.addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BRIDGE_SOURCE_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_FENCE_SOURCE_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)LASER_FENCE_BLOCK.get()), (RenderType)RenderType.m_110466_());
    }

    private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> new SoundEvent(new ResourceLocation("laserbridges", name)));
    }

    @Mod.EventBusSubscriber(modid="laserbridges", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerBlockColors(ColorHandlerEvent.Block event) {
            event.getBlockColors().m_92589_((state, level, pos, tintIndex) -> (int)(DyeColor.m_41053_((int)((Integer)state.m_61143_((Property)BridgeSourceBlock.COLOR))).m_41068_()[0] * 255.0f) << 16 | (int)(DyeColor.m_41053_((int)((Integer)state.m_61143_((Property)BridgeSourceBlock.COLOR))).m_41068_()[1] * 255.0f) << 8 | (int)(DyeColor.m_41053_((int)((Integer)state.m_61143_((Property)BridgeSourceBlock.COLOR))).m_41068_()[2] * 255.0f), new Block[]{(Block)BRIDGE_SOURCE_BLOCK.get(), (Block)LASER_FENCE_SOURCE_BLOCK.get(), (Block)LASER_BLOCK.get(), (Block)LASER_FENCE_BLOCK.get()});
        }
    }
}

