/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe668.cloudstorage.entity.BadloonHandEntity;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;

public class BadloonHandModel
extends AdvancedEntityModel<BadloonHandEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox hand;
    private final AdvancedModelBox lip;
    private final AdvancedModelBox palm;
    private final AdvancedModelBox thumb;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox indexfinger;
    private final AdvancedModelBox middlefinger;
    private final AdvancedModelBox ringfinger;

    public BadloonHandModel() {
        this.textureWidth = 32;
        this.textureHeight = 32;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 12.0f, 0.0f);
        this.hand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hand.setRotationPoint(0.0f, 12.0f, 0.0f);
        this.hand.rotateAngleY = -1.5708f;
        this.root.addChild((BasicModelPart)this.hand);
        this.lip = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lip.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.hand.addChild((BasicModelPart)this.lip);
        this.lip.setTextureOffset(0, 12).addBox(-2.5f, -12.0f, -3.0f, 4.0f, 1.0f, 6.0f, 0.0f, false);
        this.lip.setTextureOffset(14, 12).addBox(-2.0f, -11.0f, -2.0f, 3.0f, 1.0f, 4.0f, 0.0f, false);
        this.palm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.palm.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.hand.addChild((BasicModelPart)this.palm);
        this.palm.setTextureOffset(0, 0).addBox(-2.5f, -10.0f, -4.0f, 4.0f, 4.0f, 8.0f, 0.0f, false);
        this.thumb = new AdvancedModelBox((AdvancedEntityModel)this);
        this.thumb.setRotationPoint(-1.0f, -8.0f, 3.5f);
        this.hand.addChild((BasicModelPart)this.thumb);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.thumb.addChild((BasicModelPart)this.cube_r1);
        this.cube_r1.setTextureOffset(16, 0).addBox(-0.75f, -1.0f, 0.25f, 2.0f, 2.0f, 3.0f, 0.0f, false);
        this.indexfinger = new AdvancedModelBox((AdvancedEntityModel)this);
        this.indexfinger.setRotationPoint(-1.0f, -7.0f, 2.75f);
        this.hand.addChild((BasicModelPart)this.indexfinger);
        this.indexfinger.setTextureOffset(0, 19).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.middlefinger = new AdvancedModelBox((AdvancedEntityModel)this);
        this.middlefinger.setRotationPoint(-1.0f, -7.0f, 0.0f);
        this.hand.addChild((BasicModelPart)this.middlefinger);
        this.middlefinger.setTextureOffset(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.ringfinger = new AdvancedModelBox((AdvancedEntityModel)this);
        this.ringfinger.setRotationPoint(-1.0f, -7.0f, -2.75f);
        this.hand.addChild((BasicModelPart)this.ringfinger);
        this.ringfinger.setTextureOffset(18, 17).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.hand, (Object)this.lip, (Object)this.palm, (Object)this.thumb, (Object)this.cube_r1, (Object)this.indexfinger, (Object)this.middlefinger, (Object)this.ringfinger);
    }

    public void setupAnim(BadloonHandEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.root.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.hand.setRotationPoint(0.0f, 12.0f, 0.0f);
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float gestureProgress = entity.prevGestureProgress + (entity.gestureProgress - entity.prevGestureProgress) * partialTicks;
        this.animateForGesture(entity.getPrevGesture(), ageInTicks, 1.0f - gestureProgress);
        this.animateForGesture(entity.getGesture(), ageInTicks, gestureProgress);
    }

    private void animateForGesture(GloveGesture gesture, float ageInTicks, float progress) {
        float twiddleSpeed = 0.15f;
        float twiddleDegree = 0.3f;
        float indexScale = gesture == GloveGesture.POINT ? 1.5f : 1.0f;
        float middleScale = gesture == GloveGesture.FLIPOFF ? 1.5f : 1.0f;
        this.indexfinger.setScale(1.0f, indexScale, 1.0f);
        this.middlefinger.setScale(1.0f, middleScale, 1.0f);
        if (gesture == GloveGesture.GRAB) {
            this.progressPositionPrev(this.root, progress, 0.0f, 2.0f, 2.0f, 1.0f);
            this.progressRotationPrev(this.root, progress, (float)Math.toRadians(-90.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.thumb, progress, 0.0f, (float)Math.toRadians(50.0), (float)Math.toRadians(20.0), 1.0f);
            this.progressRotationPrev(this.indexfinger, progress, (float)Math.toRadians(20.0), 0.0f, (float)Math.toRadians(-20.0), 1.0f);
            this.progressRotationPrev(this.middlefinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-20.0), 1.0f);
            this.progressRotationPrev(this.ringfinger, progress, (float)Math.toRadians(-20.0), 0.0f, (float)Math.toRadians(-20.0), 1.0f);
        } else if (gesture == GloveGesture.WAVE) {
            this.progressPositionPrev(this.root, progress, 0.0f, 2.0f, 0.0f, 1.0f);
            this.progressPositionPrev(this.thumb, progress, 0.0f, -1.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.root, progress, (float)Math.toRadians(-170.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.thumb, progress, (float)Math.toRadians(-70.0), 0.0f, 0.0f, 1.0f);
            this.flap(this.root, 0.5f, 0.5f, false, 0.0f, 0.0f, ageInTicks, progress);
        } else if (gesture == GloveGesture.PUNCH) {
            this.progressRotationPrev(this.root, progress, (float)Math.toRadians(-90.0), 0.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.middlefinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
            this.progressRotationPrev(this.indexfinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
            this.progressRotationPrev(this.ringfinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
            this.progressPositionPrev(this.middlefinger, progress, 0.0f, 1.0f, 0.0f, 1.0f);
            this.progressPositionPrev(this.indexfinger, progress, 0.0f, 1.25f, 0.0f, 1.0f);
            this.progressPositionPrev(this.ringfinger, progress, 0.0f, 1.0f, 0.0f, 1.0f);
            this.progressRotationPrev(this.thumb, progress, 0.0f, (float)Math.toRadians(90.0), 0.0f, 1.0f);
        } else if (gesture == GloveGesture.POINT) {
            this.progressPositionPrev(this.root, progress, 0.0f, 2.0f, 2.0f, 1.0f);
            this.progressRotationPrev(this.root, progress, (float)Math.toRadians(-90.0), 0.0f, (float)Math.toRadians(90.0), 1.0f);
            this.progressPositionPrev(this.middlefinger, progress, 0.0f, 1.25f, 0.0f, 1.0f);
            this.progressPositionPrev(this.ringfinger, progress, -1.0f, 1.25f, 0.0f, 1.0f);
            this.progressRotationPrev(this.middlefinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
            this.progressRotationPrev(this.ringfinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
        } else if (gesture == GloveGesture.FLIPOFF) {
            this.progressPositionPrev(this.root, progress, 0.0f, 2.0f, 0.0f, 1.0f);
            this.progressPositionPrev(this.thumb, progress, 0.0f, -1.0f, 1.0f, 1.0f);
            this.progressRotationPrev(this.root, progress, (float)Math.toRadians(-170.0), (float)Math.toRadians(-180.0), 0.0f, 1.0f);
            this.progressRotationPrev(this.ringfinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
            this.progressPositionPrev(this.ringfinger, progress, 0.0f, 1.25f, 0.0f, 1.0f);
            this.progressRotationPrev(this.indexfinger, progress, 0.0f, 0.0f, (float)Math.toRadians(-110.0), 1.0f);
            this.progressPositionPrev(this.indexfinger, progress, 0.0f, 1.25f, 0.0f, 1.0f);
            this.progressRotationPrev(this.thumb, progress, 0.0f, (float)Math.toRadians(90.0), 0.0f, 1.0f);
        } else {
            this.walk(this.thumb, twiddleSpeed, twiddleDegree, false, 0.0f, -0.3f, ageInTicks, progress);
            this.flap(this.indexfinger, twiddleSpeed, twiddleDegree, false, 1.0f, -0.3f, ageInTicks, progress);
            this.flap(this.middlefinger, twiddleSpeed, twiddleDegree, false, 2.0f, -0.3f, ageInTicks, progress);
            this.flap(this.ringfinger, twiddleSpeed, twiddleDegree, false, 3.0f, -0.3f, ageInTicks, progress);
        }
    }

    public void applyTransformsToItem(PoseStack poseStack) {
        this.root.translateRotate(poseStack);
        this.hand.translateRotate(poseStack);
        this.palm.translateRotate(poseStack);
    }
}

