/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe668.cloudstorage.block.AbstractCloudChestBlockEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.Entity;

public class CloudChestModel<T extends Entity>
extends AdvancedEntityModel<T> {
    private final AdvancedModelBox bottom;
    private final AdvancedModelBox lid;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;

    public CloudChestModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.bottom = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bottom.setPos(7.0f, 24.0f, -7.0f);
        this.bottom.setTextureOffset(0, 19).addBox(-14.0f, -10.0f, 0.0f, 14.0f, 10.0f, 14.0f, 0.0f, false);
        this.lid = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lid.setPos(-7.0f, -10.0f, 14.0f);
        this.bottom.addChild((BasicModelPart)this.lid);
        this.lid.setTextureOffset(0, 0).addBox(-7.0f, -4.0f, -14.0f, 14.0f, 5.0f, 14.0f, 0.0f, false);
        this.lid.setTextureOffset(0, 0).addBox(-1.0f, -1.0f, -15.0f, 2.0f, 4.0f, 1.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.bottom);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.bottom, (Object)this.lid);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
    }

    public void renderChest(AbstractCloudChestBlockEntity entity, float partialTicks) {
        this.resetToDefaultPose();
        float open = entity.getOpenProgress(partialTicks);
        this.lid.rotateAngleX -= open * (float)Math.PI * 0.5f;
        this.walk(this.lid, 0.2f, 0.1f, false, 2.0f, -0.1f, (float)entity.tickCount + partialTicks, open);
    }
}

