/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.render;

import com.github.alexthe668.cloudstorage.client.model.BalloonModel;
import com.github.alexthe668.cloudstorage.client.render.BalloonFaceLayer;
import com.github.alexthe668.cloudstorage.client.render.BalloonTextures;
import com.github.alexthe668.cloudstorage.client.render.StringRenderHelper;
import com.github.alexthe668.cloudstorage.entity.BadloonHandEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;

public class RenderBalloonBuddy
extends MobRenderer<BalloonBuddyEntity, BalloonModel<BalloonBuddyEntity>> {
    public RenderBalloonBuddy(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new BalloonModel(), 0.3f);
        this.m_115326_(new BalloonFaceLayer(this));
    }

    public boolean shouldRender(BalloonBuddyEntity entity, Frustum frustum, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, frustum, x, y, z)) {
            return true;
        }
        Entity hand = entity.getHandForRendering();
        return hand != null && frustum.m_113029_(hand.m_142469_());
    }

    protected float getFlipDegrees(BalloonBuddyEntity entity) {
        return 0.0f;
    }

    @Nullable
    protected RenderType getRenderType(BalloonBuddyEntity entity, boolean defColor, boolean invis, boolean v) {
        ResourceLocation resourcelocation = this.getTextureLocation(entity);
        if (invis) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (defColor) {
            return RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return v ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public void render(BalloonBuddyEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        int color = entityIn.getBalloonColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ((BalloonModel)this.f_115290_).setColor(r, g, b);
        ((BalloonModel)this.f_115290_).setAlpha(entityIn.getAlpha(partialTicks));
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        ((BalloonModel)this.f_115290_).setColor(1.0f, 1.0f, 1.0f);
        Entity entity = entityIn.getHandForRendering();
        if (entity instanceof BadloonHandEntity) {
            BadloonHandEntity hand = (BadloonHandEntity)entity;
            double d0 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
            double d1 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
            double d2 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
            float xRot = entityIn.f_19860_ + (entityIn.m_146909_() - entityIn.f_19860_) * partialTicks;
            float yRot = entityIn.f_19859_ + (entityIn.m_146908_() - entityIn.f_19859_) * partialTicks;
            float zRot = entityIn.prevRotZ + (entityIn.getRotZ() - entityIn.prevRotZ) * partialTicks;
            double d3 = Mth.m_14139_((double)partialTicks, (double)hand.f_19790_, (double)hand.m_20185_());
            double d4 = Mth.m_14139_((double)partialTicks, (double)hand.f_19791_, (double)hand.m_20186_());
            double d5 = Mth.m_14139_((double)partialTicks, (double)hand.f_19792_, (double)hand.m_20189_());
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-d0, -d1, -d2);
            Vec3 position = new Vec3(d0, d1, d2);
            Vec3 handPosition = new Vec3(d3, d4, d5);
            Vec3 from = new Vec3(0.0, (double)0.2f, 0.0).m_82496_(xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180)).m_82535_(-zRot * ((float)Math.PI / 180));
            Vec3 to = handPosition.m_82520_(0.0, (double)(hand.m_20206_() * 0.8f), 0.0);
            StringRenderHelper.renderSting((Entity)entityIn, position.m_82549_(from), partialTicks, matrixStackIn, bufferIn, to, packedLightIn);
            matrixStackIn.m_85849_();
        }
    }

    protected void setupRotations(BalloonBuddyEntity entity, PoseStack poseStack, float unused, float yRotIn, float partialTicks) {
        Pose pose;
        if (this.m_5936_((LivingEntity)entity)) {
            yRotIn += (float)(Math.cos((double)entity.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entity.m_20089_()) != Pose.SLEEPING) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yRotIn));
            float zRot = entity.prevRotZ + (entity.getRotZ() - entity.prevRotZ) * partialTicks;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRot));
        }
        if (entity.f_20919_ > 0) {
            float f = ((float)entity.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f * this.getFlipDegrees(entity)));
        } else if (entity.m_21209_()) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - entity.m_146909_()));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(((float)entity.f_19797_ + partialTicks) * -75.0f));
        } else if (RenderBalloonBuddy.m_194453_((LivingEntity)entity)) {
            poseStack.m_85837_(0.0, (double)(entity.m_20206_() + 0.1f), 0.0);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    public ResourceLocation getTextureLocation(BalloonBuddyEntity entity) {
        return entity.m_6084_() ? BalloonTextures.BALLOON : BalloonTextures.POPPED;
    }
}

