/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import com.github.alexthe668.cloudstorage.entity.LivingBalloon;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BadloonHandEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(BadloonHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> GESTURE = SynchedEntityData.m_135353_(BadloonHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PREV_GESTURE = SynchedEntityData.m_135353_(BadloonHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float gestureProgress = 1.0f;
    public float prevGestureProgress;
    public GloveGesture prevPrevGuesture;

    public BadloonHandEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public BadloonHandEntity(LivingEntity parent) {
        super((EntityType)CSEntityRegistry.BADLOON_HAND.get(), parent.f_19853_);
        this.setParent((Entity)parent);
    }

    public BadloonHandEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)CSEntityRegistry.BADLOON_HAND.get(), world);
        this.m_20331_(true);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(GESTURE, (Object)0);
        this.f_19804_.m_135372_(PREV_GESTURE, (Object)0);
    }

    public boolean m_6000_(double x, double y, double z) {
        Entity parent = this.getParent();
        return super.m_6000_(x, y, z) || parent != null && parent.m_6000_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_());
    }

    public void m_8119_() {
        if (this.prevPrevGuesture != this.getPrevGesture()) {
            this.prevPrevGuesture = this.getPrevGesture();
            this.gestureProgress = 0.0f;
        }
        this.prevGestureProgress = this.gestureProgress;
        if (!this.f_19853_.f_46443_) {
            Entity parent = this.getParent();
            if (parent == null || parent instanceof LivingBalloon && !((LivingBalloon)parent).getChildId().equals(this.m_142081_())) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            this.m_20101_();
            if (parent != null) {
                Vec3 vector3d = new Vec3(parent.m_20185_() - this.m_20185_(), 0.0, parent.m_20189_() - this.m_20189_());
                float f = Mth.m_14116_((float)((float)(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)));
                this.faceTowardsX((float)((double)(f * 1.0f) * 57.2957763671875));
                this.faceTowardsY(parent.m_146908_());
                Vec3 newMovement = this.m_20184_().m_82549_(this.moveTowardsParent(0.02f)).m_82490_((double)0.9f);
                if (this.f_19862_ && this.m_20270_(parent) > 2.0f) {
                    double yUp = parent.m_20186_() - this.m_20186_();
                    newMovement = newMovement.m_82520_(0.0, yUp * (double)0.06f, 0.0);
                } else if (parent instanceof BalloonBuddyEntity && ((BalloonBuddyEntity)parent).m_21825_() && parent.m_20186_() - 1.0 < this.m_20186_()) {
                    newMovement = newMovement.m_82520_(0.0, (double)-0.05f, 0.0);
                }
                if (newMovement.m_82556_() > (double)1.0E-4f) {
                    this.m_20256_(newMovement);
                }
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            double d0 = this.m_20185_() + this.m_20184_().f_82479_;
            double d1 = this.m_20186_() + this.m_20184_().f_82480_;
            double d2 = this.m_20189_() + this.m_20184_().f_82481_;
            this.m_20343_(d0, d1, d2);
        }
        if (this.getPrevGesture() != this.getGesture() && this.gestureProgress < 1.0f) {
            this.gestureProgress += 0.25f;
        }
        if (this.getPrevGesture() == this.getGesture() && this.gestureProgress > 0.0f) {
            this.gestureProgress -= 0.25f;
        }
        if (!this.f_19853_.f_46443_ && this.m_20160_()) {
            this.setGesture(GloveGesture.GRAB);
        }
    }

    private void faceTowardsX(float f) {
        this.m_146926_(BalloonFace.rotlerp(this.m_146909_(), Mth.m_14036_((float)f, (float)-75.0f, (float)75.0f), 25.0f));
    }

    private void faceTowardsY(float f) {
        this.m_146922_(BalloonFace.rotlerp(this.m_146908_(), f, 25.0f));
    }

    private Vec3 moveTowardsParent(float speed) {
        Entity parent = this.getParent();
        if (parent != null) {
            float f = this.getGesture().holdsInFront() ? 0.5f : -0.5f;
            Vec3 gestAdd = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 target = parent.m_20182_().m_82492_(0.0, 2.0, 0.0).m_82549_(gestAdd).m_82546_(this.m_20182_());
            return target.m_82541_().m_82490_((double)speed);
        }
        return Vec3.f_82478_;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7332_(Entity entity) {
        entity.m_6034_(this.m_20185_(), this.m_20186_() + (double)0.4f - (double)entity.m_20206_(), this.m_20189_());
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_142081_());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("ParentUUID")) {
            this.setParentId(tag.m_128342_("ParentUUID"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.getParentId() != null) {
            tag.m_128362_("ParentUUID", this.getParentId());
        }
    }

    private void setGestureInt(int g) {
        this.f_19804_.m_135381_(GESTURE, (Object)g);
    }

    public void setGesture(GloveGesture gesture) {
        if (this.getGesture() != gesture) {
            this.f_19804_.m_135381_(PREV_GESTURE, (Object)this.getGesture().ordinal());
        }
        this.setGestureInt(gesture.ordinal());
    }

    public GloveGesture getGesture() {
        return GloveGesture.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(GESTURE)), (int)0, (int)5)];
    }

    public GloveGesture getPrevGesture() {
        return GloveGesture.values()[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(PREV_GESTURE)), (int)0, (int)5)];
    }
}

