/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity.ai;

import com.github.alexthe668.cloudstorage.entity.BadloonEntity;
import com.github.alexthe668.cloudstorage.entity.BadloonHandEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.GloveGesture;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.Vec3;

public class BadloonAttackGoal
extends Goal {
    private BadloonEntity badloon;
    private Entity pickupMonster = null;
    private int tryPickupCheckIn = 0;
    private int punchCooldown = 0;
    private int punchTicks = 0;

    public BadloonAttackGoal(BadloonEntity badloon) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.badloon = badloon;
    }

    public boolean m_8036_() {
        return this.badloon.m_5448_() != null && this.badloon.m_5448_().m_6084_() && this.badloon.fearOfBeingPoppedCooldown == 0;
    }

    public void m_8041_() {
        this.badloon.setFace(BalloonFace.NEUTRAL);
        this.badloon.setHandGesture(GloveGesture.IDLE);
        this.pickupMonster = null;
        this.punchTicks = 0;
    }

    public void m_8056_() {
        BadloonHandEntity hand;
        this.badloon.setFace(BalloonFace.ANGRY);
        this.tryPickupCheckIn = 0;
        this.punchCooldown = 0;
        Entity entity = this.badloon.getChild();
        if (entity instanceof BadloonHandEntity && !(hand = (BadloonHandEntity)entity).m_20197_().isEmpty()) {
            this.pickupMonster = (Entity)hand.m_20197_().get(0);
        }
    }

    public void m_8037_() {
        this.badloon.m_21310_(0);
        boolean moveTowardsTarget = true;
        float extraY = 1.3f;
        Entity hand = this.badloon.getChild();
        if (hand == null) {
            return;
        }
        if (this.punchCooldown > 0) {
            --this.punchCooldown;
        }
        if (this.pickupMonster != null) {
            if (this.pickupMonster.m_20365_(hand)) {
                this.badloon.setHandGesture(GloveGesture.GRAB);
                if (hand.m_20186_() > this.badloon.m_5448_().m_20186_() + (double)this.pickupMonster.m_20206_() && this.getXZDistanceTo(this.badloon.m_5448_().m_20182_()) < 0.5) {
                    this.dropMob();
                }
            } else if (this.pickupMonster.m_20159_()) {
                this.pickupMonster = null;
            } else {
                this.badloon.m_21566_().m_6849_(this.pickupMonster.m_20185_(), this.pickupMonster.m_20188_() + (double)1.2f, this.pickupMonster.m_20189_(), 1.0);
                if (hand.m_20270_(this.pickupMonster) < 3.0f) {
                    this.pickupMonster.m_7998_(hand, true);
                }
                moveTowardsTarget = false;
            }
        } else if (this.tryPickupCheckIn > 0) {
            --this.tryPickupCheckIn;
        } else {
            this.findMobToPickup();
            this.tryPickupCheckIn = 50;
        }
        if ((double)this.badloon.m_5448_().f_19789_ >= 3.0) {
            BadloonHandEntity glove;
            if (this.pickupMonster != null && this.pickupMonster.m_20365_(hand)) {
                this.dropMob();
            }
            if (hand instanceof BadloonHandEntity && (glove = (BadloonHandEntity)hand).getGesture() != GloveGesture.FLIPOFF && glove.getGesture() != GloveGesture.WAVE) {
                this.badloon.setHandGesture(this.badloon.m_21187_().nextInt(2) == 0 ? GloveGesture.FLIPOFF : GloveGesture.WAVE);
            }
        } else if (moveTowardsTarget) {
            double targetX = this.badloon.m_5448_().m_20185_();
            double targetZ = this.badloon.m_5448_().m_20189_();
            if (this.badloon.f_19863_ && !this.badloon.m_20096_() && !this.badloon.m_142582_((Entity)this.badloon.m_5448_())) {
                Vec3 lookRotated = new Vec3(0.0, 0.0, 2.0).m_82524_(-this.badloon.m_146908_() * ((float)Math.PI / 180));
                targetX = this.badloon.m_20185_() + lookRotated.f_82479_;
                targetZ = this.badloon.m_20189_() + lookRotated.f_82481_;
            }
            this.badloon.m_21566_().m_6849_(targetX, this.badloon.m_5448_().m_20188_() + (double)extraY, targetZ, 1.0);
        }
        if (this.pickupMonster == null && this.punchCooldown == 0 && (hand.m_20270_((Entity)this.badloon.m_5448_()) < this.badloon.m_5448_().m_20205_() + 0.5f || hand.m_142469_().m_82381_(this.badloon.m_5448_().m_142469_()))) {
            ++this.punchTicks;
            this.badloon.setHandGesture(GloveGesture.PUNCH);
            if (this.punchTicks > 3) {
                this.badloon.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this.badloon), 2.0f);
                this.badloon.setHandGesture(GloveGesture.IDLE);
                this.punchTicks = 0;
                this.punchCooldown = 5 + this.badloon.m_21187_().nextInt(10);
            }
        }
    }

    public void findMobToPickup() {
        Predicate<Entity> monsterAway = animal -> animal instanceof Monster && !(animal instanceof BadloonEntity) && animal.m_20270_((Entity)this.badloon.m_5448_()) > 5.0f && !animal.m_20159_();
        List list = this.badloon.f_19853_.m_6443_(Mob.class, this.badloon.m_5448_().m_142469_().m_82377_(30.0, 12.0, 30.0), EntitySelector.f_20408_.and(monsterAway));
        list.sort(Comparator.comparingDouble(arg_0 -> ((BadloonEntity)this.badloon).m_20280_(arg_0)));
        if (!list.isEmpty()) {
            this.pickupMonster = (Entity)list.get(0);
        }
    }

    public void dropMob() {
        this.pickupMonster.m_8127_();
        if (this.pickupMonster instanceof Creeper) {
            ((Creeper)this.pickupMonster).m_32312_();
        }
        this.punchCooldown = 30;
        this.pickupMonster = null;
    }

    public double getXZDistanceTo(Vec3 vec3) {
        return Mth.m_14116_((float)((float)this.badloon.m_20275_(vec3.f_82479_, this.badloon.m_20186_(), vec3.f_82481_)));
    }
}

