/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity.ai;

import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;

public class BalloonBuddyFollowGoal
extends Goal {
    private final BalloonBuddyEntity balloon;
    private LivingEntity owner;
    private final LevelReader world;
    private final double followSpeed;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private final boolean teleportToLeaves;

    public BalloonBuddyFollowGoal(BalloonBuddyEntity tameable, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.balloon = tameable;
        this.world = tameable.f_19853_;
        this.followSpeed = speed;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.balloon.m_142480_();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.balloon.m_21827_()) {
            return false;
        }
        if (this.balloon.m_20280_((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return this.balloon.shouldFollow();
    }

    public boolean m_8045_() {
        if (this.balloon.m_21827_()) {
            return false;
        }
        return this.balloon.m_20280_((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.owner = null;
        this.balloon.clearMovement();
    }

    public void m_8037_() {
        this.balloon.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.balloon.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.balloon.m_21523_() && !this.balloon.m_20159_()) {
                if (this.balloon.m_20280_((Entity)this.owner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                }
                this.balloon.m_21566_().m_6849_(this.owner.m_20185_(), this.owner.m_20186_() + (double)this.owner.m_20206_(), this.owner.m_20189_(), this.followSpeed);
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.balloon.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.balloon.m_146908_(), this.balloon.m_146909_());
        Entity hand = this.balloon.getChild();
        if (hand != null) {
            hand.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.balloon.m_146908_(), this.balloon.m_146909_());
        }
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        if (this.world.m_8055_(pos).m_60795_()) {
            BlockPos blockpos = pos.m_141950_((Vec3i)this.balloon.m_142538_());
            return this.world.m_45756_((Entity)this.balloon, this.balloon.m_142469_().m_82338_(blockpos));
        }
        NodeEvaluator nodeevaluator = this.balloon.m_21573_().m_26575_();
        BlockPathTypes pathnodetype = nodeevaluator.m_8086_((BlockGetter)this.world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (pathnodetype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.m_8055_(pos.m_7495_());
        if (!this.teleportToLeaves && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_141950_((Vec3i)this.balloon.m_142538_());
        return this.world.m_45756_((Entity)this.balloon, this.balloon.m_142469_().m_82338_(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.balloon.m_21187_().nextInt(max - min + 1) + min;
    }
}

