/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity.villager;

import com.github.alexthe666.citadel.server.generation.VillageHouseManager;
import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.block.CSPOIRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.villager.BuyingItemTrade;
import com.github.alexthe668.cloudstorage.entity.villager.SellingItemTrade;
import com.github.alexthe668.cloudstorage.entity.villager.SellingMap;
import com.github.alexthe668.cloudstorage.entity.villager.SellingRandomlyDyedItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import com.github.alexthe668.cloudstorage.world.BalloonStandPoolElement;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.MoveToSkySeeingSpot;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cloudstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CSVillagerRegistry {
    public static final VillagerProfession BALLOON_SALESMAN = (VillagerProfession)new BalloonSalesman().setRegistryName("cloudstorage", "balloon_salesman");
    public static final StructurePoolElementType<BalloonStandPoolElement> BALLOON_STAND_TYPE = (StructurePoolElementType)Registry.m_122965_((Registry)Registry.f_122892_, (ResourceLocation)new ResourceLocation("cloudstorage", "balloon_stand"), () -> BalloonStandPoolElement.CODEC);
    public static boolean registeredHouses = false;

    @SubscribeEvent
    public static void registerVillagers(RegistryEvent.Register<VillagerProfession> event) {
        if (((Boolean)CloudStorage.CONFIG.balloonSalesmanVillager.get()).booleanValue()) {
            event.getRegistry().register((IForgeRegistryEntry)BALLOON_SALESMAN);
        }
    }

    public static void initTrades(List<VillagerTrades.ItemListing> level1, List<VillagerTrades.ItemListing> level2, List<VillagerTrades.ItemListing> level3, List<VillagerTrades.ItemListing> level4, List<VillagerTrades.ItemListing> level5) {
        level1.add(new BuyingItemTrade((ItemLike)Items.f_42401_, 10, 3, 11, 2));
        level1.add(new SellingItemTrade((Item)CSItemRegistry.BALLOON_BIT.get(), 2, 3, 13, 2));
        level1.add(new SellingItemTrade((Item)CSItemRegistry.COTTON_CANDY.get(), 2, 7, 13, 3));
        level1.add(new BuyingItemTrade((ItemLike)Items.f_42590_, 8, 2, 11, 2));
        level2.add(new BuyingItemTrade((ItemLike)CSItemRegistry.GUIDE_BOOK.get(), 8, 2, 11, 2));
        level2.add(new SellingItemTrade((Item)CSItemRegistry.BALLOON.get(), 2, 5, 13, 4));
        level2.add(new SellingRandomlyDyedItem((Item)CSItemRegistry.BALLOON.get(), 1, 2, 13, 4));
        level2.add(new SellingRandomlyDyedItem((Item)CSItemRegistry.BALLOON.get(), 4, 2, 13, 4));
        level3.add(new SellingItemTrade((Block)CSBlockRegistry.CLOUD.get(), 2, 4, 11, 8));
        level3.add(new BuyingItemTrade((ItemLike)CSItemRegistry.ANGRY_CLOUD_IN_A_BOTTLE.get(), 8, 4, 4, 9));
        level3.add(new SellingItemTrade(Items.f_42689_, 3, 9, 4, 9));
        level3.add(new SellingItemTrade(Items.f_42669_, 3, 4, 4, 9));
        level3.add(new SellingItemTrade(Items.f_151059_, 5, 1, 2, 9));
        level3.add(new SellingMap(10, true, "item.cloudstorage.big_balloon_map", MapDecoration.Type.TARGET_POINT, 1, 13));
        level3.add(new SellingMap(10, false, "item.cloudstorage.sky_temple_map", MapDecoration.Type.TARGET_X, 1, 13));
        level4.add(new SellingItemTrade((Item)CSItemRegistry.PROPELLER_HAT.get(), 11, 1, 1, 15));
        level4.add(new SellingItemTrade((Block)CSBlockRegistry.STATIC_CLOUD.get(), 3, 5, 6, 13));
        level4.add(new BuyingItemTrade((ItemLike)CSItemRegistry.HAPPY_CLOUD_IN_A_BOTTLE.get(), 8, 6, 7, 12));
        level5.add(new SellingItemTrade((Item)CSItemRegistry.BALLOON_BUDDY.get(), 15, 1, 10, 15));
        level5.add(new SellingRandomlyDyedItem((Item)CSItemRegistry.BALLOON_BUDDY.get(), 13, 1, 3, 15));
        level5.add(new SellingRandomlyDyedItem((Item)CSItemRegistry.BALLOON.get(), 6, 2, 13, 5));
    }

    public static void registerHouses() {
        registeredHouses = true;
        int weight = (Integer)CloudStorage.CONFIG.balloonStandSpawnWeight.get();
        BalloonStandPoolElement plains = new BalloonStandPoolElement(new ResourceLocation("cloudstorage", "balloon_stand_plains"), (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
        VillageHouseManager.register((String)"minecraft:village/plains/houses", arg_0 -> CSVillagerRegistry.lambda$registerHouses$1((StructurePoolElement)plains, weight, arg_0));
        BalloonStandPoolElement desert = new BalloonStandPoolElement(new ResourceLocation("cloudstorage", "balloon_stand_desert"), (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
        VillageHouseManager.register((String)"minecraft:village/desert/houses", arg_0 -> CSVillagerRegistry.lambda$registerHouses$2((StructurePoolElement)desert, weight, arg_0));
        BalloonStandPoolElement savanna = new BalloonStandPoolElement(new ResourceLocation("cloudstorage", "balloon_stand_savanna"), (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
        VillageHouseManager.register((String)"minecraft:village/savanna/houses", arg_0 -> CSVillagerRegistry.lambda$registerHouses$3((StructurePoolElement)savanna, weight, arg_0));
        BalloonStandPoolElement snowy = new BalloonStandPoolElement(new ResourceLocation("cloudstorage", "balloon_stand_snowy"), (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
        VillageHouseManager.register((String)"minecraft:village/snowy/houses", arg_0 -> CSVillagerRegistry.lambda$registerHouses$4((StructurePoolElement)snowy, weight, arg_0));
        BalloonStandPoolElement taiga = new BalloonStandPoolElement(new ResourceLocation("cloudstorage", "balloon_stand_taiga"), (Holder<StructureProcessorList>)ProcessorLists.f_127198_);
        VillageHouseManager.register((String)"minecraft:village/taiga/houses", arg_0 -> CSVillagerRegistry.lambda$registerHouses$5((StructurePoolElement)taiga, weight, arg_0));
    }

    public static void onBalloonCelebrate(ServerLevel level, Villager villager) {
        Random random = villager.m_21187_();
        if (random.nextInt(75) == 0) {
            villager.m_35310_();
            if (MoveToSkySeeingSpot.m_23558_((ServerLevel)level, (LivingEntity)villager, (BlockPos)villager.m_142538_())) {
                int[] colors = CSVillagerRegistry.getBalloonColorsForVillager(villager.m_7141_().m_35560_());
                for (int i = 0; i < random.nextInt(2) + 1; ++i) {
                    int color = colors[colors.length <= 1 ? 0 : random.nextInt(colors.length)];
                    BalloonEntity balloon = (BalloonEntity)((EntityType)CSEntityRegistry.BALLOON.get()).m_20615_(villager.f_19853_);
                    balloon.m_20359_((Entity)villager);
                    balloon.setStringLength(1 + random.nextInt(1));
                    balloon.setBalloonColor(color);
                    villager.f_19853_.m_7967_((Entity)balloon);
                }
            }
        }
    }

    public static int[] getBalloonColorsForVillager(VillagerType type) {
        if (type == VillagerType.f_35821_) {
            return new int[]{15149353, 16701501};
        }
        if (type == VillagerType.f_35819_) {
            return new int[]{8439583, 3847130, 16701501};
        }
        if (type == VillagerType.f_35822_) {
            return new int[]{16701501, 8606770, 16351261};
        }
        if (type == VillagerType.f_35823_) {
            return new int[]{3847130, 3949738};
        }
        if (type == VillagerType.f_35825_) {
            return new int[]{15149353, 3847130};
        }
        return new int[]{15149353};
    }

    private static /* synthetic */ void lambda$registerHouses$5(StructurePoolElement taiga, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool((StructureTemplatePool)pool, (StructurePoolElement)taiga, (int)weight);
    }

    private static /* synthetic */ void lambda$registerHouses$4(StructurePoolElement snowy, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool((StructureTemplatePool)pool, (StructurePoolElement)snowy, (int)weight);
    }

    private static /* synthetic */ void lambda$registerHouses$3(StructurePoolElement savanna, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool((StructureTemplatePool)pool, (StructurePoolElement)savanna, (int)weight);
    }

    private static /* synthetic */ void lambda$registerHouses$2(StructurePoolElement desert, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool((StructureTemplatePool)pool, (StructurePoolElement)desert, (int)weight);
    }

    private static /* synthetic */ void lambda$registerHouses$1(StructurePoolElement plains, int weight, StructureTemplatePool pool) {
        VillageHouseManager.addToPool((StructureTemplatePool)pool, (StructurePoolElement)plains, (int)weight);
    }

    private static class BalloonSalesman
    extends VillagerProfession {
        public BalloonSalesman() {
            super("balloon_salesman", null, ImmutableSet.of(), ImmutableSet.of(), CSSoundRegistry.BALLOON_HURT);
        }

        public PoiType m_35622_() {
            return (PoiType)CSPOIRegistry.BALLOON_STAND.get();
        }
    }
}

