/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.inventory;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.inventory.CSMenuRegistry;
import com.github.alexthe668.cloudstorage.inventory.ItemSorting;
import com.github.alexthe668.cloudstorage.inventory.SlotCloudChest;
import com.github.alexthe668.cloudstorage.network.MessageScrollCloudChest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class CloudChestMenu
extends AbstractContainerMenu {
    private final DataSlot scrollAmount = DataSlot.m_39401_();
    private final Container container;
    private final int playerInvStart = 0;
    private final int playerInvEnd = 0;
    private final Map<ItemStack, Integer> restoreFromAfterSearch = new HashMap<ItemStack, Integer>();
    public String currentSearch = "";

    public CloudChestMenu(int id, Inventory playerInv) {
        this(id, playerInv, (Container)new SimpleContainer(CloudStorage.PROXY.getVisibleCloudSlots()));
    }

    public CloudChestMenu(int id, Inventory playerInv, Container containerIn) {
        super(CSMenuRegistry.CLOUD_CHEST_MENU, id);
        this.container = containerIn;
        containerIn.m_5856_(playerInv.f_35978_);
        int clampedSize = Math.min(containerIn.m_6643_(), 54);
        int ySlots = clampedSize / 9;
        for (int k = 0; k < ySlots; ++k) {
            for (int l = 0; l < 9 && l + k * 9 < clampedSize; ++l) {
                this.m_38897_(new SlotCloudChest(this.container, l + k * 9, 8 + l * 18, 18 + k * 18){

                    @Override
                    public int getScrollIndex() {
                        return this.f_40217_ + 9 * Math.max(CloudChestMenu.this.getScrollAmount(), 0);
                    }
                });
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.m_38897_(new Slot((Container)playerInv, k1 + i1 * 9 + 9, 8 + k1 * 18, 140 + i1 * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.m_38897_(new Slot((Container)playerInv, j1, 8 + j1 * 18, 198));
        }
        CloudStorage.PROXY.setVisibleCloudSlots(containerIn.m_6643_());
        this.m_38895_(this.scrollAmount).m_6422_(0);
        this.scrollTo(0.0f, false);
    }

    public static boolean matchesSearch(Player player, String search, ItemStack stack) {
        boolean matches = false;
        for (Component line : stack.m_41651_(player, (TooltipFlag)TooltipFlag.Default.ADVANCED)) {
            if (!ChatFormatting.m_126649_((String)line.getString()).toLowerCase(Locale.ROOT).contains(search)) continue;
            matches = true;
            break;
        }
        if (search.startsWith("@")) {
            String modid = search.substring(1);
            matches = stack.m_41720_().getRegistryName().m_135827_().contains(modid);
        } else if (search.startsWith("#")) {
            String tagId = search.substring(1);
            List tags = stack.m_204131_().toList();
            for (TagKey tag : tags) {
                ResourceLocation registryName = tag.f_203868_();
                if (!registryName.toString().contains(tagId)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public void scrollTo(float scrollProgress, boolean sendPacket) {
        int maxScrollDown = this.container.m_6643_() / 9 - 6;
        int i = Math.max((int)Math.floor(scrollProgress * (float)maxScrollDown), 0);
        if (sendPacket) {
            CloudStorage.NETWORK_WRAPPER.sendToServer((Object)new MessageScrollCloudChest(i));
        }
        this.scrollAmount.m_6422_(i);
    }

    public int getScrollAmount() {
        return this.scrollAmount.m_6501_();
    }

    public void setScrollAmount(int i) {
        this.scrollAmount.m_6422_(i);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        int clampedSize = Math.min(this.container.m_6643_(), 54);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex < clampedSize ? !this.m_38903_(itemstack1, clampedSize, this.f_38839_.size(), true) : !this.moveItemStackToScrollable(itemstack1, 0, this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean moveItemStackToScrollable(ItemStack beingMoved, int startAt, int endAt, boolean moveBackwards) {
        boolean flag = false;
        int i = startAt;
        if (moveBackwards) {
            i = endAt - 1;
        }
        if (beingMoved.m_41753_()) {
            while (!beingMoved.m_41619_() && !(!moveBackwards ? i >= endAt : i < startAt)) {
                ItemStack itemstack = this.container.m_8020_(i);
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)beingMoved, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + beingMoved.m_41613_();
                    if (j <= (maxSize = Math.min(itemstack.m_41741_(), beingMoved.m_41741_()))) {
                        beingMoved.m_41764_(0);
                        itemstack.m_41764_(j);
                        this.container.m_6596_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        beingMoved.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        this.container.m_6596_();
                        flag = true;
                    }
                }
                if (moveBackwards) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!beingMoved.m_41619_()) {
            i = moveBackwards ? endAt - 1 : startAt;
            while (!(!moveBackwards ? i >= endAt : i < startAt)) {
                ItemStack itemstack1 = this.container.m_8020_(i);
                if (itemstack1.m_41619_()) {
                    if (beingMoved.m_41613_() > itemstack1.m_41741_()) {
                        this.container.m_6836_(i, beingMoved.m_41620_(itemstack1.m_41741_()));
                    } else {
                        this.container.m_6836_(i, beingMoved.m_41620_(beingMoved.m_41613_()));
                    }
                    this.container.m_6596_();
                    flag = true;
                    break;
                }
                if (moveBackwards) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void updateGrays(Player player, String currentSearch) {
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof SlotCloudChest)) continue;
            SlotCloudChest cloudChest = (SlotCloudChest)slot;
            cloudChest.setGray(!currentSearch.isEmpty() && !CloudChestMenu.matchesSearch(player, currentSearch, cloudChest.m_7993_()));
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    public void sort(Comparator<ItemStack> comparator) {
        NonNullList<ItemStack> itemList = NonNullList.m_122779_();
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            if (this.container.m_8020_(i).m_41619_()) continue;
            itemList.add((Object)this.container.m_8020_(i));
        }
        itemList.sort(comparator);
        itemList = ItemSorting.combineStacks(this.container, itemList);
        this.container.m_6211_();
        for (int j = 0; j < this.container.m_6643_() && j < itemList.size(); ++j) {
            this.container.m_6836_(j, (ItemStack)itemList.get(j));
        }
        this.container.m_6596_();
        this.m_38946_();
    }

    public void search(Player player, String search) {
        if (search.isEmpty()) {
            if (!this.restoreFromAfterSearch.isEmpty()) {
                ArrayList<ItemStack> extras = new ArrayList<ItemStack>();
                for (int i = 0; i < this.container.m_6643_(); ++i) {
                    ItemStack stack = this.container.m_8020_(i);
                    if (this.restoreFromAfterSearch.get(stack) != null) continue;
                    extras.add(stack);
                }
                this.container.m_6211_();
                for (Map.Entry<ItemStack, Integer> stackEntry : this.restoreFromAfterSearch.entrySet()) {
                    this.container.m_6836_(stackEntry.getValue().intValue(), stackEntry.getKey());
                }
                for (ItemStack newStack : extras) {
                    ItemSorting.addItem(this.container, newStack);
                }
                this.restoreFromAfterSearch.clear();
            }
        } else {
            NonNullList matches = NonNullList.m_122779_();
            NonNullList noMatches = NonNullList.m_122779_();
            boolean reset = this.restoreFromAfterSearch.isEmpty();
            for (int i = 0; i < this.container.m_6643_(); ++i) {
                ItemStack stack = this.container.m_8020_(i);
                if (!stack.m_41619_()) {
                    if (CloudChestMenu.matchesSearch(player, search, stack)) {
                        matches.add((Object)stack);
                    } else {
                        noMatches.add((Object)stack);
                    }
                }
                if (!reset) continue;
                this.restoreFromAfterSearch.put(this.container.m_8020_(i), i);
            }
            matches.sort(ItemSorting::defaultCompare);
            noMatches.sort(ItemSorting::defaultCompare);
            this.container.m_6211_();
            matches.addAll((Collection)noMatches);
            for (int j = 0; j < this.container.m_6643_() && j < matches.size(); ++j) {
                this.container.m_6836_(j, (ItemStack)matches.get(j));
            }
        }
        this.updateGrays(player, search);
        this.container.m_6596_();
        this.m_38946_();
    }

    public boolean isSlotGray(int i) {
        Slot slot = this.m_38853_(i);
        if (slot instanceof SlotCloudChest) {
            SlotCloudChest slot2 = (SlotCloudChest)slot;
            return slot2.isGray();
        }
        return false;
    }
}

