/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.item;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.item.BalloonArrowItem;
import com.github.alexthe668.cloudstorage.item.BalloonBuddyItem;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.BlockItemSpecialRender;
import com.github.alexthe668.cloudstorage.item.CloudBottleItem;
import com.github.alexthe668.cloudstorage.item.GuideBookItem;
import com.github.alexthe668.cloudstorage.item.PropellerHatItem;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="cloudstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CSItemRegistry {
    public static final DeferredRegister<Item> DEF_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"cloudstorage");
    public static final RegistryObject<Item> BALLOON_BIT = DEF_REG.register("balloon_bit", () -> new Item(new Item.Properties().m_41491_(CloudStorage.TAB)));
    public static final RegistryObject<Item> GUIDE_BOOK = DEF_REG.register("guide_book", () -> new GuideBookItem(new Item.Properties().m_41491_(CloudStorage.TAB).m_41487_(1)));
    public static final RegistryObject<Item> BALLOON_INVENTORY = DEF_REG.register("balloon_inventory", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BALLOON = DEF_REG.register("balloon", () -> new BalloonItem());
    public static final RegistryObject<Item> ANGRY_CLOUD_IN_A_BOTTLE = DEF_REG.register("angry_cloud_in_a_bottle", () -> new CloudBottleItem(false));
    public static final RegistryObject<Item> HAPPY_CLOUD_IN_A_BOTTLE = DEF_REG.register("happy_cloud_in_a_bottle", () -> new CloudBottleItem(true));
    public static final RegistryObject<Item> BALLOON_BUDDY_INVENTORY = DEF_REG.register("balloon_buddy_inventory", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BALLOON_BUDDY = DEF_REG.register("balloon_buddy", () -> new BalloonBuddyItem());
    public static final RegistryObject<Item> BALLOON_ARROW = DEF_REG.register("balloon_arrow", () -> new BalloonArrowItem());
    public static final RegistryObject<Item> PROPELLER_HAT = DEF_REG.register("propeller_hat", () -> new PropellerHatItem());
    public static final RegistryObject<Item> COTTON_CANDY = DEF_REG.register("cotton_candy", () -> new Item(new Item.Properties().m_41491_(CloudStorage.TAB).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.15f).m_38766_().m_38767_())));
    public static final RegistryObject<Item> MUSIC_DISC_DRIFT = DEF_REG.register("music_disc_drift", () -> new RecordItem(14, CSSoundRegistry.MUSIC_DISC_DRIFT, new Item.Properties().m_41491_(CloudStorage.TAB).m_41487_(1).m_41497_(Rarity.RARE)));

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)((Item)new ForgeSpawnEggItem(CSEntityRegistry.BADLOON, 15149353, 0xEEE7E1, new Item.Properties().m_41491_(CloudStorage.TAB)).setRegistryName("cloudstorage:spawn_egg_badloon")));
        event.getRegistry().register((IForgeRegistryEntry)((Item)new ForgeSpawnEggItem(CSEntityRegistry.BLOVIATOR, 14676983, 2404351, new Item.Properties().m_41491_(CloudStorage.TAB)).setRegistryName("cloudstorage:spawn_egg_bloviator")));
        CSBlockRegistry.DEF_REG.getEntries().stream().map(RegistryObject::get).forEach(block -> event.getRegistry().register((IForgeRegistryEntry)CSItemRegistry.registerItemBlock(block)));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)BALLOON.get()), (blockSource, itemStack) -> {
            Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            if (((BalloonItem)BALLOON.get()).placeBalloon((Level)blockSource.m_7727_(), itemStack, blockSource.m_7961_(), direction, null, true)) {
                itemStack.m_41774_(1);
            }
            return itemStack;
        });
    }

    private static Item registerItemBlock(Block block) {
        Item.Properties props = new Item.Properties();
        props.m_41491_(CloudStorage.TAB);
        BlockItemSpecialRender blockItem = block == CSBlockRegistry.CLOUD_CHEST.get() || block == CSBlockRegistry.STATIC_CLOUD_CHEST.get() ? new BlockItemSpecialRender(block, props) : new BlockItem(block, props);
        blockItem.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        return blockItem;
    }
}

