/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.misc;

import java.lang.reflect.Field;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cloudstorage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CSSoundRegistry {
    public static final SoundEvent BALLOON_HURT = CSSoundRegistry.createSoundEvent("balloon_hurt");
    public static final SoundEvent BALLOON_POP = CSSoundRegistry.createSoundEvent("balloon_pop");
    public static final SoundEvent BLOVIATOR_IDLE = CSSoundRegistry.createSoundEvent("bloviator_idle");
    public static final SoundEvent BLOVIATOR_HURT = CSSoundRegistry.createSoundEvent("bloviator_hurt");
    public static final SoundEvent BLOVIATOR_BLOW = CSSoundRegistry.createSoundEvent("bloviator_blow");
    public static final SoundEvent BLOVIATOR_LIGHTNING = CSSoundRegistry.createSoundEvent("bloviator_lightning");
    public static final SoundEvent CLOUD_CHEST_OPEN = CSSoundRegistry.createSoundEvent("cloud_chest_open");
    public static final SoundEvent CLOUD_CHEST_CLOSE = CSSoundRegistry.createSoundEvent("cloud_chest_close");
    public static final SoundEvent STATIC_SHOCK = CSSoundRegistry.createSoundEvent("static_shock");
    public static final SoundEvent MUSIC_DISC_DRIFT = CSSoundRegistry.createSoundEvent("music_disc_drift");

    private static SoundEvent createSoundEvent(String soundName) {
        ResourceLocation soundID = new ResourceLocation("cloudstorage", soundName);
        return (SoundEvent)new SoundEvent(soundID).setRegistryName(soundID);
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        try {
            for (Field f : CSSoundRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof SoundEvent) {
                    event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)obj));
                    continue;
                }
                if (!(obj instanceof SoundEvent[])) continue;
                for (SoundEvent soundEvent : (SoundEvent[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)soundEvent);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

