/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ConfigWithVariants;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.gui.quests.ChapterPanel;
import dev.ftb.mods.ftbquests.gui.quests.ExpandChaptersButton;
import dev.ftb.mods.ftbquests.gui.quests.OtherButtonsPanelBottom;
import dev.ftb.mods.ftbquests.gui.quests.OtherButtonsPanelTop;
import dev.ftb.mods.ftbquests.gui.quests.QuestButton;
import dev.ftb.mods.ftbquests.gui.quests.QuestPanel;
import dev.ftb.mods.ftbquests.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.gui.quests.ViewQuestPanel;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class QuestScreen
extends BaseScreen {
    public final ClientQuestFile file;
    public double scrollWidth;
    public double scrollHeight;
    public int prevMouseX;
    public int prevMouseY;
    public MouseButton grabbed = null;
    public Chapter selectedChapter;
    public final List<Movable> selectedObjects;
    public final ExpandChaptersButton expandChaptersButton;
    public final ChapterPanel chapterPanel;
    public final QuestPanel questPanel;
    public final OtherButtonsPanelBottom otherButtonsBottomPanel;
    public final OtherButtonsPanelTop otherButtonsTopPanel;
    public final ViewQuestPanel viewQuestPanel;
    public boolean movingObjects = false;
    public int zoom = 16;
    public long lastShiftPress = 0L;
    public static boolean grid = false;

    public QuestScreen(ClientQuestFile q) {
        this.file = q;
        this.selectedObjects = new ArrayList<Movable>();
        this.expandChaptersButton = new ExpandChaptersButton(this);
        this.chapterPanel = new ChapterPanel((Panel)this);
        this.selectedChapter = this.file.getFirstVisibleChapter(this.file.self);
        this.questPanel = new QuestPanel((Panel)this);
        this.otherButtonsBottomPanel = new OtherButtonsPanelBottom((Panel)this);
        this.otherButtonsTopPanel = new OtherButtonsPanelTop((Panel)this);
        this.viewQuestPanel = new ViewQuestPanel(this);
        this.selectChapter(null);
    }

    @Nullable
    public Quest getViewedQuest() {
        return this.viewQuestPanel.quest;
    }

    public boolean isViewingQuest() {
        return this.getViewedQuest() != null;
    }

    public void addWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.add((Widget)this.questPanel);
        this.add((Widget)this.chapterPanel);
        this.add(this.expandChaptersButton);
        this.add((Widget)this.otherButtonsBottomPanel);
        this.add((Widget)this.otherButtonsTopPanel);
        this.add((Widget)this.viewQuestPanel);
    }

    public void alignWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.otherButtonsBottomPanel.alignWidgets();
        this.otherButtonsTopPanel.alignWidgets();
        this.chapterPanel.alignWidgets();
        this.expandChaptersButton.setPosAndSize(0, 0, 20, this.height);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        super.onClosed();
    }

    public void selectChapter(@Nullable Chapter chapter) {
        if (this.selectedChapter != chapter) {
            this.closeQuest();
            this.selectedChapter = chapter;
            this.questPanel.refreshWidgets();
            this.questPanel.resetScroll();
        }
    }

    public void viewQuest(Quest quest) {
        if (this.viewQuestPanel.quest != quest) {
            this.viewQuestPanel.quest = quest;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void onBack() {
        if (this.isViewingQuest()) {
            this.closeQuest();
        } else {
            super.onBack();
        }
    }

    public void closeQuest() {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.hidePanel = false;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void toggleSelected(Movable movable) {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.refreshWidgets();
        }
        if (this.selectedObjects.contains(movable)) {
            this.selectedObjects.remove(movable);
        } else {
            this.selectedObjects.add(movable);
        }
    }

    public void addObjectMenuItems(List<ContextMenuItem> contextMenu, Runnable gui, QuestObjectBase object) {
        Movable m;
        this.addObjectMenuItems(contextMenu, gui, object, object instanceof Movable ? (m = (Movable)((Object)object)) : null);
    }

    public void addObjectMenuItems(List<ContextMenuItem> contextMenu, Runnable gui, QuestObjectBase object, Movable deletionFocus) {
        Component[] componentArray;
        long delId;
        QuestObjectBase delObject;
        RandomReward rr;
        ConfigGroup group = new ConfigGroup("ftbquests");
        ConfigGroup subGroup = object.createSubGroup(group);
        object.getConfig(subGroup);
        contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> object.onEditButtonClicked(gui)));
        if (object instanceof QuestLink) {
            QuestLink link = (QuestLink)object;
            link.getQuest().ifPresent(quest -> contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.edit_linked_quest"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> quest.onEditButtonClicked(gui))));
        }
        if (!subGroup.getValues().isEmpty()) {
            contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.copy_id.quick_properties"), Icons.SETTINGS, () -> this.openPropertiesSubMenu(object, subGroup)));
        }
        if (object instanceof RandomReward && !QuestObjectBase.isNull((rr = (RandomReward)object).getTable())) {
            contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.reward_table.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> rr.getTable().onEditButtonClicked(gui)));
        }
        if ((delObject = ClientQuestFile.INSTANCE.getBase(delId = deletionFocus == null ? object.id : deletionFocus.getMovableID())) != null) {
            ContextMenuItem delete = new ContextMenuItem((Component)new TranslatableComponent("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> ClientQuestFile.INSTANCE.deleteObject(delId));
            if (!QuestScreen.isShiftKeyDown()) {
                delete.setYesNo((Component)new TranslatableComponent("delete_item", new Object[]{delObject.getTitle()}));
            }
            contextMenu.add(delete);
        }
        contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> ChangeProgressMessage.send(this.file.self, object, progressChange -> {
            progressChange.reset = true;
        })).setYesNo((Component)new TranslatableComponent("ftbquests.gui.reset_progress_q")));
        contextMenu.add(new ContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), () -> ChangeProgressMessage.send(this.file.self, object, progressChange -> {
            progressChange.reset = false;
        })).setYesNo((Component)new TranslatableComponent("ftbquests.gui.complete_instantly_q")));
        if (object instanceof Quest) {
            Component[] componentArray2 = new Component[2];
            componentArray2[0] = new TextComponent(QuestObjectBase.getCodeString(object));
            componentArray = componentArray2;
            componentArray2[1] = new TranslatableComponent("ftbquests.gui.copy_id.paste_hint").m_130940_(ChatFormatting.GRAY);
        } else {
            Component[] componentArray3 = new Component[1];
            componentArray = componentArray3;
            componentArray3[0] = new TextComponent(QuestObjectBase.getCodeString(object));
        }
        Component[] tooltip = componentArray;
        contextMenu.add(new TooltipContextMenuItem((Component)new TranslatableComponent("ftbquests.gui.copy_id"), (Icon)ThemeProperties.WIKI_ICON.get(), () -> QuestScreen.setClipboardString((String)object.getCodeString()), tooltip));
    }

    private void openPropertiesSubMenu(final QuestObjectBase object, ConfigGroup g) {
        ArrayList<ContextMenuItem> subMenu = new ArrayList<ContextMenuItem>();
        subMenu.add(new ContextMenuItem(object.getTitle(), (Icon)Icon.EMPTY, null).setCloseMenu(false));
        subMenu.add(ContextMenuItem.SEPARATOR);
        for (final ConfigValue c : g.getValues()) {
            if (!(c instanceof ConfigWithVariants)) continue;
            TranslatableComponent name = new TranslatableComponent(c.getNameKey());
            if (!c.getCanEdit()) {
                name = name.m_130940_(ChatFormatting.GRAY);
            }
            subMenu.add(new ContextMenuItem((Component)name, Icons.SETTINGS, null){

                public void addMouseOverText(TooltipList list) {
                    list.add(c.getStringForGUI(c.value));
                }

                public void onClicked(Panel panel, MouseButton button) {
                    c.onClicked(button, accepted -> {
                        if (accepted) {
                            c2.setter.accept(c2.value);
                            new EditObjectMessage(object).sendToServer();
                        }
                    });
                }

                public void drawIcon(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
                    c.getIcon(c.value).draw(matrixStack, x, y, w, h);
                }
            });
        }
        this.getGui().openContextMenu(subMenu);
    }

    public static void displayError(Component error) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)new TranslatableComponent("ftbquests.gui.error"), error));
    }

    private boolean moveSelectedQuests(double x, double y) {
        for (Movable movable : this.selectedObjects) {
            if (movable.getChapter() != this.selectedChapter) continue;
            movable.move(this.selectedChapter, movable.getX() + x, movable.getY() + y);
        }
        return true;
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            if (this.contextMenu != null) {
                this.openContextMenu(null);
                return true;
            }
            if (this.isViewingQuest()) {
                this.closeQuest();
                return true;
            }
        }
        if (super.keyPressed(key)) {
            return true;
        }
        if (FTBQuestsClient.KEY_QUESTS.m_90832_(key.keyCode, key.scanCode)) {
            this.closeGui(true);
            return true;
        }
        if (key.is(258)) {
            List<Chapter> visibleChapters;
            if (this.selectedChapter != null && this.file.getVisibleChapters(this.file.self).size() > 1 && !(visibleChapters = this.file.getVisibleChapters(this.file.self)).isEmpty()) {
                this.selectChapter(visibleChapters.get(MathUtils.mod((int)(visibleChapters.indexOf(this.selectedChapter) + (QuestScreen.isShiftKeyDown() ? -1 : 1)), (int)visibleChapters.size())));
            }
            return true;
        }
        if (key.is(32)) {
            this.questPanel.resetScroll();
            return true;
        }
        if (key.is(82) && key.modifiers.onlyControl()) {
            grid = !grid;
            return true;
        }
        if (key.keyCode >= 49 && key.keyCode <= 57) {
            int i = key.keyCode - 49;
            if (i < this.file.getVisibleChapters(this.file.self).size()) {
                this.selectChapter(this.file.getVisibleChapters(this.file.self).get(i));
            }
            return true;
        }
        if (key.modifiers.control() && this.selectedChapter != null && this.file.canEdit()) {
            double step = key.modifiers.shift() ? 0.1 : 0.5;
            switch (key.keyCode) {
                case 65: {
                    this.selectedObjects.addAll(this.selectedChapter.quests);
                    this.selectedObjects.addAll(this.selectedChapter.questLinks);
                    return true;
                }
                case 68: {
                    this.selectedObjects.clear();
                    return true;
                }
                case 264: {
                    return this.moveSelectedQuests(0.0, step);
                }
                case 265: {
                    return this.moveSelectedQuests(0.0, -step);
                }
                case 263: {
                    return this.moveSelectedQuests(-step, 0.0);
                }
                case 262: {
                    return this.moveSelectedQuests(step, 0.0);
                }
                case 48: {
                    this.addZoom((double)(16 - this.zoom) / 4.0);
                    return true;
                }
                case 70: {
                    this.openQuestSelectionGUI();
                    return true;
                }
            }
        }
        if (key.keyCode == 340 || key.keyCode == 344) {
            long now = System.currentTimeMillis();
            if (now - this.lastShiftPress <= 400L) {
                this.openQuestSelectionGUI();
                this.lastShiftPress = 0L;
            } else {
                this.lastShiftPress = now;
            }
        }
        return false;
    }

    private void openQuestSelectionGUI() {
        ConfigQuestObject c = new ConfigQuestObject(QuestObjectType.CHAPTER.or(QuestObjectType.QUEST).or(QuestObjectType.QUEST_LINK));
        SelectQuestObjectScreen gui = new SelectQuestObjectScreen(c, accepted -> {
            if (accepted) {
                Object patt13003$temp = c.value;
                if (patt13003$temp instanceof Chapter) {
                    Chapter chapter = (Chapter)patt13003$temp;
                    this.selectChapter(chapter);
                } else {
                    Object patt13085$temp = c.value;
                    if (patt13085$temp instanceof Quest) {
                        Quest quest = (Quest)patt13085$temp;
                        this.zoom = 20;
                        this.selectChapter(quest.chapter);
                        this.viewQuestPanel.hidePanel = false;
                        this.viewQuest(quest);
                    } else {
                        Object patt13247$temp = c.value;
                        if (patt13247$temp instanceof QuestLink) {
                            QuestLink link = (QuestLink)patt13247$temp;
                            this.zoom = 20;
                            this.selectChapter(link.getChapter());
                            this.viewQuestPanel.hidePanel = false;
                            link.getQuest().ifPresent(this::viewQuest);
                        }
                    }
                }
            }
            this.openGui();
        });
        gui.focus();
        gui.setTitle((Component)new TranslatableComponent("gui.search_box"));
        gui.openGui();
    }

    public void tick() {
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null) {
            this.selectChapter(this.file.getFirstVisibleChapter(this.file.self));
        }
        super.tick();
    }

    public int getZoom() {
        return this.zoom;
    }

    public double getQuestButtonSize() {
        return (double)this.getZoom() * 3.0 / 2.0;
    }

    public double getQuestButtonSpacing() {
        return (double)this.getZoom() * (Double)ThemeProperties.QUEST_SPACING.get(this.selectedChapter) / 4.0;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = (int)Mth.m_14008_((double)((double)this.zoom + up * 4.0), (double)4.0, (double)28.0);
        if (this.zoom != z) {
            this.grabbed = null;
            double sx = this.questPanel.centerQuestX;
            double sy = this.questPanel.centerQuestY;
            this.questPanel.resetScroll();
            this.questPanel.scrollTo(sx, sy);
        }
    }

    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        QuestTheme.currentObject = this.selectedChapter;
        super.drawBackground(matrixStack, theme, x, y, w, h);
        int pw = 20;
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        Color4I backgroundColor = (Color4I)ThemeProperties.WIDGET_BACKGROUND.get(this.selectedChapter);
        borderColor.draw(matrixStack, x + pw - 1, y + 1, 1, h - 2);
        backgroundColor.draw(matrixStack, x + 1, y + 1, pw - 2, h - 2);
        borderColor.draw(matrixStack, x + w - pw, y + 1, 1, h - 2);
        backgroundColor.draw(matrixStack, x + w - pw + 1, y + 1, pw - 2, h - 2);
        if (this.grabbed != null) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.grabbed.isLeft()) {
                if (this.scrollWidth > (double)this.questPanel.width) {
                    this.questPanel.setScrollX(Math.max(Math.min(this.questPanel.getScrollX() + (double)(this.prevMouseX - mx), this.scrollWidth - (double)this.questPanel.width), 0.0));
                } else {
                    this.questPanel.setScrollX((this.scrollWidth - (double)this.questPanel.width) / 2.0);
                }
                if (this.scrollHeight > (double)this.questPanel.height) {
                    this.questPanel.setScrollY(Math.max(Math.min(this.questPanel.getScrollY() + (double)(this.prevMouseY - my), this.scrollHeight - (double)this.questPanel.height), 0.0));
                } else {
                    this.questPanel.setScrollY((this.scrollHeight - (double)this.questPanel.height) / 2.0);
                }
                this.prevMouseX = mx;
                this.prevMouseY = my;
            } else if (this.grabbed.isMiddle()) {
                int boxX = Math.min(this.prevMouseX, mx);
                int boxY = Math.min(this.prevMouseY, my);
                int boxW = Math.abs(mx - this.prevMouseX);
                int boxH = Math.abs(my - this.prevMouseY);
                GuiHelper.drawHollowRect((PoseStack)matrixStack, (int)boxX, (int)boxY, (int)boxW, (int)boxH, (Color4I)Color4I.DARK_GRAY, (boolean)false);
                Color4I.DARK_GRAY.withAlpha(40).draw(matrixStack, boxX, boxY, boxW, boxH);
            }
        }
    }

    void selectAllQuestsInBox(int mouseX, int mouseY, double scrollX, double scrollY) {
        int x1 = Math.min(this.prevMouseX, mouseX);
        int x2 = Math.max(this.prevMouseX, mouseX);
        int y1 = Math.min(this.prevMouseY, mouseY);
        int y2 = Math.max(this.prevMouseY, mouseY);
        Rect2i rect = new Rect2i(x1, y1, x2 - x1, y2 - y1);
        if (!Screen.m_96637_()) {
            this.selectedObjects.clear();
        }
        this.questPanel.widgets.forEach(w -> {
            if (w instanceof QuestButton) {
                QuestButton qb = (QuestButton)w;
                if (rect.m_110087_((int)((double)w.getX() - scrollX), (int)((double)w.getY() - scrollY))) {
                    this.toggleSelected(qb.moveAndDeleteFocus());
                }
            }
        });
    }

    public void drawForeground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        GuiHelper.drawHollowRect((PoseStack)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)borderColor, (boolean)false);
        super.drawForeground(matrixStack, theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground(PoseStack matrixStack) {
        return false;
    }

    public void open(@Nullable QuestObject object, boolean focus) {
        if (object instanceof Chapter) {
            Chapter chapter = (Chapter)object;
            this.selectChapter(chapter);
        } else if (object instanceof Quest) {
            Quest quest2 = (Quest)object;
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(quest2.chapter);
            this.viewQuest(quest2);
            if (focus) {
                this.questPanel.scrollTo(quest2.x + 0.5, quest2.y + 0.5);
            }
        } else if (object instanceof QuestLink) {
            QuestLink link = (QuestLink)object;
            link.getQuest().ifPresent(quest -> {
                this.viewQuestPanel.hidePanel = false;
                this.viewQuest((Quest)quest);
                if (focus) {
                    this.questPanel.scrollTo(quest.x + 0.5, quest.y + 0.5);
                }
            });
        } else if (object instanceof Task) {
            Task task = (Task)object;
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(task.quest.chapter);
            this.viewQuest(task.quest);
        }
        this.openGui();
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(this.file.getID(path)), true);
            return true;
        }
        return super.handleClick(scheme, path);
    }

    public void addMouseOverText(TooltipList list) {
        list.zOffset = 950;
        list.zOffsetItemTooltip = 500;
        super.addMouseOverText(list);
    }

    public void addInfoTooltip(TooltipList list, QuestObjectBase object) {
        if (QuestScreen.isKeyDown((int)290) || QuestScreen.isShiftKeyDown() && QuestScreen.isCtrlKeyDown()) {
            Date c;
            list.add((Component)new TextComponent(object.getCodeString()).m_130940_(ChatFormatting.DARK_GRAY));
            if (object instanceof QuestObject) {
                Date c2;
                Date s = this.file.self.getStartedTime(object.id);
                if (s != null) {
                    list.add((Component)new TextComponent("Started: ").m_130946_(s.toLocaleString()).m_130940_(ChatFormatting.DARK_GRAY));
                }
                if ((c2 = this.file.self.getCompletedTime(object.id)) != null) {
                    list.add((Component)new TextComponent("Completed: ").m_130946_(c2.toLocaleString()).m_130940_(ChatFormatting.DARK_GRAY));
                }
            } else if (object instanceof Reward && (c = this.file.self.getRewardClaimTime(Minecraft.m_91087_().f_91074_.m_142081_(), (Reward)object)) != null) {
                list.add((Component)new TextComponent("Claimed: ").m_130946_(c.toLocaleString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public Collection<Quest> getSelectedQuests() {
        HashMap questMap = new HashMap();
        this.selectedObjects.forEach(movable -> {
            if (movable instanceof Quest) {
                Quest q2 = (Quest)movable;
                questMap.put(q2.id, q2);
            } else if (movable instanceof QuestLink) {
                QuestLink ql = (QuestLink)movable;
                ql.getQuest().ifPresent(q -> questMap.put(q.id, q));
            }
        });
        return List.copyOf(questMap.values());
    }
}

