/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.block.entity;

import iskallia.ispawner.block.entity.BaseBlockEntity;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.init.ModBlocks;
import iskallia.ispawner.init.ModConfigs;
import iskallia.ispawner.inventory.SimpleInventory;
import iskallia.ispawner.screen.handler.SurvivalSpawnerScreenHandler;
import iskallia.ispawner.world.spawner.SpawnerAction;
import iskallia.ispawner.world.spawner.SpawnerExecution;
import iskallia.ispawner.world.spawner.SpawnerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SurvivalSpawnerBlockEntity
extends SpawnerBlockEntity {
    public SimpleInventory input = new SimpleInventory(1){

        @Override
        public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
            return ModConfigs.SURVIVAL_SPAWNER.isWhitelisted(stack);
        }
    };

    public SurvivalSpawnerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlocks.Entities.SURVIVAL_SPAWNER.get(), pos, state);
    }

    public SurvivalSpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.input.addListener(this);
    }

    public SimpleInventory getInput() {
        return this.input;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SurvivalSpawnerBlockEntity spawner) {
        if (world == null || world.m_5776_()) {
            return;
        }
        SpawnerSettings newConfig = ModConfigs.SURVIVAL_SPAWNER.defaultSettings.copy();
        newConfig.setMode(spawner.manager.settings.getMode());
        if (!spawner.manager.settings.equals(newConfig)) {
            spawner.manager.settings = newConfig;
            spawner.sendClientUpdates();
        }
        spawner.inventory.m_6836_(0, spawner.input.m_8020_(0).m_41777_());
        if (spawner.manager.actions.isEmpty()) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    for (int y = -2; y <= 1; ++y) {
                        int weight = 4 - Math.max(Math.abs(x), Math.abs(z)) + 1;
                        Rotation rotation = spawner.getReverseRotation();
                        Vec3 hitPosOffset = new Vec3(0.5, 1.0, 0.5);
                        spawner.manager.addAction(new SpawnerAction(SpawnerBlockEntity.mirror(new BlockPos(x, y, z), spawner.getMirror()).m_7954_(rotation), Direction.UP, SpawnerAction.rotate(rotation, SpawnerBlockEntity.mirror(hitPosOffset, spawner.getMirror())), InteractionHand.MAIN_HAND, new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN}), weight);
                    }
                }
            }
        }
        spawner.manager.tick(world, world.m_5822_(), spawner, SpawnerExecution.SUMMON);
    }

    @Override
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new SurvivalSpawnerScreenHandler(syncId, inv, this);
    }

    @Override
    public void onChargeUsed(ItemStack stack, int index) {
        this.inventory.m_6836_(index, stack);
    }

    @Override
    public CompoundTag write(CompoundTag tag, BaseBlockEntity.UpdateType type) {
        CompoundTag nbt = super.write(tag, type);
        nbt.m_128365_("Input", (Tag)this.input.writeToNBT());
        return nbt;
    }

    @Override
    public void read(CompoundTag tag, BaseBlockEntity.UpdateType type) {
        super.read(tag, type);
        if (tag.m_128425_("Input", 10)) {
            this.input.readFromNBT(tag.m_128469_("Input"));
        }
    }
}

