/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.init.ModItems;
import iskallia.ispawner.util.Color;
import iskallia.ispawner.world.spawner.SpawnerController;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class SpawnerBlockRenderer<T extends SpawnerBlockEntity>
implements BlockEntityRenderer<T> {
    public static final Map<Integer, Color> COLOR_PER_WEIGHT = new LinkedHashMap<Integer, Color>();

    public SpawnerBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public int m_142163_() {
        return 128;
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        boolean rendered;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean bl = rendered = this.tryRender(entity, matrices, vertexConsumers, player.m_21120_(InteractionHand.MAIN_HAND)) || this.tryRender(entity, matrices, vertexConsumers, player.m_21120_(InteractionHand.OFF_HAND));
        if (rendered) {
            BlockPos pos = ((SpawnerBlockEntity)((Object)entity)).getOffset();
            LevelRenderer.m_109621_((PoseStack)matrices, (VertexConsumer)vertexConsumers.m_6299_(RenderType.m_110504_()), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)((double)pos.m_123341_() + 1.0), (double)((double)pos.m_123342_() + 1.0), (double)((double)pos.m_123343_() + 1.0), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            LevelRenderer.m_109621_((PoseStack)matrices, (VertexConsumer)vertexConsumers.m_6299_(RenderType.m_110504_()), (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int r = ((SpawnerBlockEntity)((Object)entity)).manager.settings.getCheckRadius();
            LevelRenderer.m_109621_((PoseStack)matrices, (VertexConsumer)vertexConsumers.m_6299_(RenderType.m_110504_()), (double)(-r), (double)(-r), (double)(-r), (double)((double)r + 1.0), (double)((double)r + 1.0), (double)((double)r + 1.0), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            r = ((SpawnerBlockEntity)((Object)entity)).manager.settings.getPlayerRadius();
            LevelRenderer.m_109621_((PoseStack)matrices, (VertexConsumer)vertexConsumers.m_6299_(RenderType.m_110504_()), (double)(-r), (double)(-r), (double)(-r), (double)((double)r + 1.0), (double)((double)r + 1.0), (double)((double)r + 1.0), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderEntity(entity, tickDelta, matrices, vertexConsumers, light, overlay);
    }

    public boolean tryRender(T entity, PoseStack matrices, MultiBufferSource vertexConsumers, ItemStack stack) {
        SpawnerController controller;
        if (stack.m_41720_() == ModItems.SPAWNER_CONTROLLER.get() && (controller = new SpawnerController(stack.m_41698_("Controller"))).getTarget().isPresent() && controller.getTarget().get().equals((Object)entity.m_58899_())) {
            ((SpawnerBlockEntity)((Object)entity)).renderer.refresh((SpawnerBlockEntity)((Object)entity));
            ((SpawnerBlockEntity)((Object)entity)).renderer.render(matrices, vertexConsumers.m_6299_(RenderType.m_110504_()), (SpawnerBlockEntity)((Object)entity));
            return true;
        }
        return false;
    }

    public boolean rendersOutsideBoundingBox(SpawnerBlockEntity blockEntity) {
        return true;
    }

    public void renderEntity(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        ItemStack stack = this.getRenderedItem(entity);
        if (stack != null) {
            matrices.m_85837_(0.5, 0.35, 0.5);
            long ticks = entity.m_58904_().m_46467_();
            double prev = (double)ticks * 9.0 % 360.0;
            double next = (prev + 9.0) % 360.0;
            matrices.m_85841_(1.5f, 1.5f, 1.5f);
            matrices.m_85845_(Vector3f.f_122225_.m_122240_((float)Mth.m_14139_((double)tickDelta, (double)prev, (double)next) - 10.0f));
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, matrices, vertexConsumers, 0);
        }
        matrices.m_85849_();
    }

    private ItemStack getRenderedItem(T entity) {
        List<ItemStack> items = IntStream.range(0, ((SpawnerBlockEntity)((Object)entity)).inventory.m_6643_()).mapToObj(((SpawnerBlockEntity)((Object)entity)).inventory::m_8020_).filter(stack -> !stack.m_41619_()).toList();
        if (items.isEmpty()) {
            return null;
        }
        int i = (int)(entity.m_58904_().m_46467_() / 40L % (long)items.size());
        return items.get(i).m_41777_();
    }

    public static Color getColorFor(int weight) {
        Color color = null;
        for (Map.Entry<Integer, Color> entry : COLOR_PER_WEIGHT.entrySet()) {
            if (entry.getKey() > weight) break;
            color = entry.getValue();
        }
        return color;
    }

    static {
        COLOR_PER_WEIGHT.put(0, new Color(0, 0, 0));
        COLOR_PER_WEIGHT.put(1, new Color(255, 0, 0));
        COLOR_PER_WEIGHT.put(2, new Color(0, 255, 0));
        COLOR_PER_WEIGHT.put(3, new Color(0, 0, 255));
        COLOR_PER_WEIGHT.put(4, new Color(255, 255, 0));
        COLOR_PER_WEIGHT.put(5, new Color(255, 0, 255));
        COLOR_PER_WEIGHT.put(6, new Color(0, 255, 255));
        COLOR_PER_WEIGHT.put(7, new Color(255, 255, 255));
    }
}

