/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.init;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import dev.architectury.registry.registries.RegistrySupplier;
import iskallia.ispawner.block.SpawnerBlock;
import iskallia.ispawner.block.SurvivalSpawnerBlock;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.block.entity.SurvivalSpawnerBlockEntity;
import iskallia.ispawner.init.ModItems;
import iskallia.ispawner.init.ModRegistries;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class ModBlocks
extends ModRegistries {
    public static RegistrySupplier<SpawnerBlock> SPAWNER;
    public static RegistrySupplier<SurvivalSpawnerBlock> SURVIVAL_SPAWNER;

    public static void register() {
        SPAWNER = ModBlocks.register("spawner", () -> new SpawnerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(100.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()), (RegistrySupplier<V> entry) -> () -> new BlockItem((Block)entry.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
        SURVIVAL_SPAWNER = ModBlocks.register("survival_spawner", () -> new SurvivalSpawnerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(50.0f, 1200.0f).m_60918_(SoundType.f_56743_).m_60955_()), (RegistrySupplier<V> entry) -> () -> new BlockItem((Block)entry.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
    }

    public static <V extends Block> RegistrySupplier<V> register(ResourceLocation id, Supplier<V> block) {
        return ModBlocks.register(id, block);
    }

    public static <V extends Block> RegistrySupplier<V> register(String name, Supplier<V> block) {
        return ModBlocks.register(name, block);
    }

    public static <V extends Block> RegistrySupplier<V> register(ResourceLocation id, Supplier<V> block, Function<RegistrySupplier<V>, Supplier<BlockItem>> item) {
        return ModBlocks.register(id, block, id, item);
    }

    public static <V extends Block> RegistrySupplier<V> register(String name, Supplier<V> block, Function<RegistrySupplier<V>, Supplier<BlockItem>> item) {
        return ModBlocks.register(name, block, name, item);
    }

    public static <V extends Block> RegistrySupplier<V> register(ResourceLocation id, Supplier<V> block, ResourceLocation itemId, Function<RegistrySupplier<V>, Supplier<BlockItem>> item) {
        Supplier<BlockItem> value;
        RegistrySupplier<V> entry = ModBlocks.register(BLOCKS, id, block);
        if (item != null && (value = item.apply(entry)) != null) {
            ModItems.register(itemId, value);
        }
        return entry;
    }

    public static <V extends Block> RegistrySupplier<V> register(String name, Supplier<V> block, String itemName, Function<RegistrySupplier<V>, Supplier<BlockItem>> item) {
        Supplier<BlockItem> value;
        RegistrySupplier<V> entry = ModBlocks.register(BLOCKS, name, block);
        if (item != null && (value = item.apply(entry)) != null) {
            ModItems.register(itemName, value);
        }
        return entry;
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(ResourceLocation id, BlockEntityType.BlockEntitySupplier<T> blockEntity, RegistrySupplier<Block> ... blocks) {
        return ModBlocks.register(id, blockEntity, Util.m_137456_((DSL.TypeReference)References.f_16781_, null), blocks);
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(ResourceLocation id, BlockEntityType.BlockEntitySupplier<T> blockEntity, String typeId, RegistrySupplier<Block> ... blocks) {
        return ModBlocks.register(id, blockEntity, Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)typeId), blocks);
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(ResourceLocation id, BlockEntityType.BlockEntitySupplier<T> blockEntity, Type<?> type, RegistrySupplier<Block> ... blocks) {
        return ModBlocks.register(BLOCK_ENTITY_TYPES, id, () -> {
            Block[] values = new Block[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                values[i] = (Block)blocks[i].get();
            }
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)blockEntity, (Block[])values).m_58966_(type);
        });
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> blockEntity, RegistrySupplier<? extends Block> ... blocks) {
        return ModBlocks.register(name, blockEntity, (Type)null, blocks);
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> blockEntity, String typeId, RegistrySupplier<? extends Block> ... blocks) {
        return ModBlocks.register(name, blockEntity, Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)typeId), blocks);
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> blockEntity, Type<?> type, RegistrySupplier<? extends Block> ... blocks) {
        return ModBlocks.register(BLOCK_ENTITY_TYPES, name, () -> {
            Block[] values = new Block[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                values[i] = (Block)blocks[i].get();
            }
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)blockEntity, (Block[])values).m_58966_(type);
        });
    }

    public static class Entities
    extends ModBlocks {
        public static RegistrySupplier<BlockEntityType<SpawnerBlockEntity>> SPAWNER;
        public static RegistrySupplier<BlockEntityType<SurvivalSpawnerBlockEntity>> SURVIVAL_SPAWNER;

        public static void register() {
            SPAWNER = Entities.register("spawner", SpawnerBlockEntity::new, SPAWNER);
            SURVIVAL_SPAWNER = Entities.register("survival_spawner", SurvivalSpawnerBlockEntity::new, SURVIVAL_SPAWNER);
        }
    }
}

