/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.inventory;

import iskallia.ispawner.nbt.INBTSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class FixedInventory
implements WorldlyContainer,
INBTSerializable<CompoundTag> {
    protected NonNullList<ItemStack> stacks;
    protected Map<Direction, int[]> availableSlots;
    protected List<ContainerListener> listeners = new ArrayList<ContainerListener>();

    public void addListener(ContainerListener arg) {
        this.listeners.add(arg);
    }

    public void removeListener(ContainerListener arg) {
        this.listeners.remove(arg);
    }

    public int[] m_7071_(Direction side) {
        return this.availableSlots.getOrDefault(side, new int[0]);
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        return true;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        return this.stacks.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return slot >= this.m_6643_() || slot < 0 ? ItemStack.f_41583_ : (ItemStack)this.stacks.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.stacks, (int)slot, (int)amount);
        if (!result.m_41619_()) {
            this.m_6596_();
        }
        return result;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack result = (ItemStack)this.stacks.get(slot);
        if (!result.m_41619_()) {
            this.stacks.set(slot, (Object)ItemStack.f_41583_);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6596_() {
        this.listeners.forEach(listener -> listener.m_5757_((Container)this));
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag stacksList = new ListTag();
        this.stacks.forEach(stack -> stacksList.add((Object)this.getStackNBT((ItemStack)stack)));
        nbt.m_128365_("Stacks", (Tag)stacksList);
        ListTag slotsList = new ListTag();
        this.availableSlots.forEach((direction, slots) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Direction", direction.ordinal());
            tag.m_128385_("Slots", slots);
            slotsList.add((Object)tag);
        });
        nbt.m_128365_("AvailableSlots", (Tag)slotsList);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.stacks.clear();
        this.availableSlots.clear();
        ListTag stacksList = nbt.m_128437_("Stacks", 10);
        for (int i = 0; i < stacksList.size() && i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)this.getStackFromNBT(stacksList.m_128728_(i)));
        }
        ListTag slotsList = nbt.m_128437_("AvailableSlots", 10);
        for (int i = 0; i < slotsList.size(); ++i) {
            CompoundTag tag = slotsList.m_128728_(i);
            Direction direction = Direction.values()[tag.m_128451_("Direction")];
            int[] slots = tag.m_128465_("Slots");
            this.availableSlots.put(direction, slots);
        }
    }

    protected CompoundTag getStackNBT(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString());
        tag.m_128405_("Count", stack.m_41613_());
        if (stack.m_41783_() != null) {
            tag.m_128365_("tag", (Tag)stack.m_41783_().m_6426_());
        }
        return tag;
    }

    protected ItemStack getStackFromNBT(CompoundTag tag) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
        stack.m_41764_(tag.m_128451_("Count"));
        return stack;
    }

    public void m_6211_() {
        this.stacks.clear();
        this.m_6596_();
    }
}

