/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.ispawner.ISpawner;
import iskallia.ispawner.block.entity.SurvivalSpawnerBlockEntity;
import iskallia.ispawner.init.ModNetwork;
import iskallia.ispawner.net.packet.UpdateRedstoneModeC2SPacket;
import iskallia.ispawner.screen.handler.SurvivalSpawnerScreenHandler;
import iskallia.ispawner.world.spawner.SpawnerSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class SurvivalSpawnerScreen
extends AbstractContainerScreen<SurvivalSpawnerScreenHandler> {
    private static final ResourceLocation TEXTURE = ISpawner.id("textures/gui/survival_spawner.png");
    private SpawnerSettings.Mode lastKnownMode = null;

    public SurvivalSpawnerScreen(SurvivalSpawnerScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_96546_ = false;
        this.f_97726_ = 176;
        this.f_97727_ = 241;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 46, this.f_97736_ + 123, 22, 22, 212, this.lastKnownMode == SpawnerSettings.Mode.ALWAYS_ON ? 66 : 88, this.lastKnownMode == SpawnerSettings.Mode.ALWAYS_ON ? 44 : 22, TEXTURE, 256, 256, btn -> {
            if (this.lastKnownMode != SpawnerSettings.Mode.ALWAYS_ON) {
                ModNetwork.CHANNEL.sendToServer((Object)new UpdateRedstoneModeC2SPacket(SpawnerSettings.Mode.ALWAYS_ON));
            }
        }, (btn, matrices, mouseX, mouseY) -> this.m_96602_(matrices, (Component)new TextComponent(SpawnerSettings.Mode.ALWAYS_ON.text), mouseX, mouseY), TextComponent.f_131282_));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 70, this.f_97736_ + 123, 22, 22, 234, this.lastKnownMode == SpawnerSettings.Mode.REDSTONE_ON ? 66 : 88, this.lastKnownMode == SpawnerSettings.Mode.REDSTONE_ON ? 44 : 22, TEXTURE, 256, 256, btn -> {
            if (this.lastKnownMode != SpawnerSettings.Mode.REDSTONE_ON) {
                ModNetwork.CHANNEL.sendToServer((Object)new UpdateRedstoneModeC2SPacket(SpawnerSettings.Mode.REDSTONE_ON));
            }
        }, (btn, matrices, mouseX, mouseY) -> this.m_96602_(matrices, (Component)new TextComponent(SpawnerSettings.Mode.REDSTONE_ON.text), mouseX, mouseY), TextComponent.f_131282_));
    }

    public void m_181908_() {
        SpawnerSettings.Mode redstoneMode;
        super.m_181908_();
        SurvivalSpawnerBlockEntity spawner = ((SurvivalSpawnerScreenHandler)this.m_6262_()).getSpawner();
        if (spawner != null && (redstoneMode = spawner.manager.settings.getMode()) != this.lastKnownMode) {
            this.lastKnownMode = redstoneMode;
            this.refreshButtons();
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(matrices, this.f_96539_, (float)(this.f_97728_ + 38), (float)this.f_97729_, 0x404040);
        EntityType<?> spawningEntity = ((SurvivalSpawnerScreenHandler)this.m_6262_()).getSpawningEntity();
        int charges = ((SurvivalSpawnerScreenHandler)this.m_6262_()).getSpawnerCharges();
        if (spawningEntity != null && charges > 0) {
            EntityDimensions size = spawningEntity.m_20680_();
            float scale = 1.0f / (Math.max(size.f_20378_, size.f_20377_) / 1.4f) * 32.0f;
            matrices.m_85836_();
            matrices.m_85837_(85.0, 80.0, 0.0);
            matrices.m_85841_(1.0f, 1.0f, -1.0f);
            matrices.m_85837_(0.0, 0.0, -200.0);
            matrices.m_85841_(scale, scale, scale);
            matrices.m_85845_(Vector3f.f_122223_.m_122240_(30.0f));
            matrices.m_85845_(Vector3f.f_122225_.m_122240_(135.0f));
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            try {
                this.renderSpawningEntity(matrices, spawningEntity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 400.0);
            this.f_96547_.m_92889_(matrices, spawningEntity.m_20676_(), 75.0f, 99.0f, 0x404040);
            this.f_96547_.m_92889_(matrices, (Component)new TextComponent("Charges: " + charges), 75.0f, 109.0f, 0x404040);
            matrices.m_85849_();
        }
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrices, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7043_() {
        return false;
    }

    private void renderSpawningEntity(PoseStack renderStack, EntityType<?> entityType) {
        EntityRenderDispatcher entityRenderer = Minecraft.m_91087_().m_91290_();
        Entity entity = entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20885_ = 0.0f;
        }
        entityRenderer.m_114468_(false);
        Lighting.m_84930_();
        MultiBufferSource.BufferSource renderBuffers = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, renderStack, (MultiBufferSource)renderBuffers, 0xF000F0);
        renderBuffers.m_109911_();
        RenderSystem.m_69482_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_69478_();
        RenderSystem.m_69493_();
        Lighting.m_84931_();
        entityRenderer.m_114468_(true);
    }
}

