/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.screen.handler;

import iskallia.ispawner.block.entity.SurvivalSpawnerBlockEntity;
import iskallia.ispawner.init.ModConfigs;
import iskallia.ispawner.init.ModMenus;
import iskallia.ispawner.inventory.SimpleInventory;
import iskallia.ispawner.screen.handler.slot.FilteredSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class SurvivalSpawnerScreenHandler
extends AbstractContainerMenu {
    private final Inventory playerInventory;
    private final SimpleInventory spawnerInventory;
    private final BlockPos spawnerPos;

    public SurvivalSpawnerScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(syncId, playerInventory, new SimpleInventory(1), extraData.m_130135_());
    }

    public SurvivalSpawnerScreenHandler(int syncId, Inventory playerInventory, SurvivalSpawnerBlockEntity spawner) {
        this(syncId, playerInventory, spawner.getInput(), spawner.m_58899_());
    }

    protected SurvivalSpawnerScreenHandler(int syncId, Inventory playerInventory, SimpleInventory spawnerInventory, BlockPos spawnerPos) {
        super((MenuType)ModMenus.SURVIVAL_SPAWNER.get(), syncId);
        this.playerInventory = playerInventory;
        this.spawnerInventory = spawnerInventory;
        this.spawnerPos = spawnerPos;
        spawnerInventory.m_5856_(playerInventory.f_35978_);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)this.playerInventory, column + row * 9 + 9, 8 + column * 18, 159 + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)this.playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 217));
        }
        this.m_38897_(new FilteredSlot((Container)this.spawnerInventory, 0, 47, 99, ModConfigs.SURVIVAL_SPAWNER::isWhitelisted));
    }

    public boolean m_6875_(Player player) {
        SurvivalSpawnerBlockEntity spawner = this.getSpawner();
        if (spawner == null) {
            return false;
        }
        return this.getSpawnerInventory().m_6542_(player) && player.m_20275_((double)this.spawnerPos.m_123341_() + 0.5, (double)this.spawnerPos.m_123342_() + 0.5, (double)this.spawnerPos.m_123343_() + 0.5) <= 64.0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 37, false)) {
                return itemStack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.getSpawnerInventory().m_5785_(player);
    }

    public Container getSpawnerInventory() {
        return this.spawnerInventory;
    }

    @Nullable
    public EntityType<?> getSpawningEntity() {
        SurvivalSpawnerBlockEntity spawner = this.getSpawner();
        if (spawner == null) {
            return null;
        }
        ItemStack stack = spawner.getInventory().m_8020_(0);
        if (stack.m_41720_() instanceof SpawnEggItem) {
            return ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        }
        return null;
    }

    public int getSpawnerCharges() {
        SurvivalSpawnerBlockEntity spawner = this.getSpawner();
        if (spawner == null) {
            return -1;
        }
        ItemStack stack = spawner.getInventory().m_8020_(0);
        return stack.m_41613_();
    }

    @Nullable
    public SurvivalSpawnerBlockEntity getSpawner() {
        BlockEntity be = this.playerInventory.f_35978_.m_20193_().m_7702_(this.spawnerPos);
        if (!(be instanceof SurvivalSpawnerBlockEntity)) {
            return null;
        }
        return (SurvivalSpawnerBlockEntity)be;
    }
}

