/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.world.spawner;

import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.item.GenericSpawnEggItem;
import iskallia.ispawner.nbt.INBTSerializable;
import iskallia.ispawner.world.spawner.SpawnerContext;
import iskallia.ispawner.world.spawner.SpawnerExecution;
import iskallia.ispawner.world.spawner.SpawnerUsageContext;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.Nullable;

public class SpawnerAction
implements INBTSerializable<CompoundTag> {
    protected BlockPos pos;
    protected Direction side;
    protected Vec3 hitPos;
    protected InteractionHand hand;
    protected Direction[] directions;

    public SpawnerAction() {
    }

    public SpawnerAction(BlockPos pos, Direction side, Vec3 hitPos, InteractionHand hand, Direction[] directions) {
        this.pos = pos;
        this.side = side;
        this.hitPos = hitPos;
        this.hand = hand;
        this.directions = directions;
    }

    public SpawnerAction toAbsolute(BlockPos pos, Rotation rotation, Mirror mirror) {
        return new SpawnerAction(SpawnerBlockEntity.mirror(this.getPos().m_7954_(rotation), mirror).m_141952_((Vec3i)pos), SpawnerBlockEntity.mirror(rotation.m_55954_(this.getSide()), mirror), SpawnerBlockEntity.mirror(SpawnerAction.rotate(rotation, this.getHitPos()), mirror).m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), this.getHand(), this.getDirections());
    }

    public static Vec3 rotate(Rotation rotation, Vec3 position) {
        switch (rotation) {
            default: {
                return position;
            }
            case CLOCKWISE_90: {
                return new Vec3(-position.m_7094_(), position.m_7098_(), position.m_7096_());
            }
            case CLOCKWISE_180: {
                return new Vec3(-position.m_7096_(), position.m_7098_(), -position.m_7094_());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new Vec3(position.m_7094_(), position.m_7098_(), -position.m_7096_());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public Vec3 getHitPos() {
        return this.hitPos;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public Direction[] getDirections() {
        return this.directions;
    }

    public boolean execute(Level world, ItemStack stack, SpawnerContext context) {
        if (stack.m_41720_() instanceof ThrowablePotionItem) {
            return this.applyPotionOverride(world, stack, context);
        }
        if (stack.m_41720_() instanceof SpawnEggItem || stack.m_41720_() instanceof GenericSpawnEggItem) {
            return this.applyEggOverride(world, stack, context);
        }
        if (context.getExecution() == SpawnerExecution.USE) {
            stack.m_41661_((UseOnContext)new SpawnerUsageContext(world, stack, this));
        }
        return true;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("Pos", this.getPos().m_121878_());
        nbt.m_128405_("Side", this.getSide().ordinal());
        nbt.m_128347_("HitPosX", this.getHitPos().f_82479_);
        nbt.m_128347_("HitPosY", this.getHitPos().f_82480_);
        nbt.m_128347_("HitPosZ", this.getHitPos().f_82481_);
        nbt.m_128405_("Hand", this.getHand().ordinal());
        nbt.m_128385_("Directions", Arrays.stream(this.getDirections()).mapToInt(Enum::ordinal).toArray());
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.pos = BlockPos.m_122022_((long)nbt.m_128454_("Pos"));
        this.side = Direction.values()[nbt.m_128451_("Side")];
        this.hitPos = new Vec3(nbt.m_128459_("HitPosX"), nbt.m_128459_("HitPosY"), nbt.m_128459_("HitPosZ"));
        this.hand = InteractionHand.values()[nbt.m_128451_("Hand")];
        this.directions = (Direction[])Arrays.stream(nbt.m_128465_("Directions")).mapToObj(i -> Direction.values()[i]).toArray(Direction[]::new);
    }

    public boolean applyPotionOverride(Level world, ItemStack stack, SpawnerContext context) {
        if (context.getExecution() != SpawnerExecution.USE) {
            return false;
        }
        ThrownPotion potion = new ThrownPotion(world, this.getHitPos().m_7096_(), this.getHitPos().m_7098_(), this.getHitPos().m_7094_());
        potion.m_37446_(stack);
        world.m_7967_((Entity)potion);
        return true;
    }

    public boolean applyEggOverride(Level world, ItemStack stack, SpawnerContext context) {
        BlockEntity blockEntity;
        EntityType type;
        BlockState state = world.m_8055_(this.getPos());
        Item item = stack.m_41720_();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem egg = (SpawnEggItem)item;
            v0 = egg.m_43228_(stack.m_41783_());
        } else {
            v0 = type = GenericSpawnEggItem.getType(stack);
        }
        if (context.getExecution() == SpawnerExecution.USE && state.m_60713_(Blocks.f_50085_) && (blockEntity = world.m_7702_(this.getPos())) instanceof net.minecraft.world.level.block.entity.SpawnerBlockEntity) {
            net.minecraft.world.level.block.entity.SpawnerBlockEntity spawner = (net.minecraft.world.level.block.entity.SpawnerBlockEntity)blockEntity;
            if (type != null) {
                spawner.m_59801_().m_45462_(type);
                spawner.m_6596_();
                world.m_7260_(this.getPos(), state, state, 3);
                stack.m_41774_(1);
            }
            return true;
        }
        BlockPos pos = state.m_60812_((BlockGetter)world, this.getPos()).m_83281_() ? this.getPos() : this.getPos().m_142300_(this.getSide());
        stack.m_41698_("EntityTag").m_128365_("Spawner", (Tag)context.getEntity().m_187482_());
        Object entity = this.create(type, (ServerLevel)world, stack.m_41783_(), stack.m_41788_() ? stack.m_41786_() : null, null, pos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(this.getPos(), pos) && this.getSide() == Direction.UP);
        if (entity != null && !world.m_45772_(entity.m_142469_())) {
            entity = null;
        }
        if (entity != null) {
            ((ServerLevel)world).m_47205_(entity);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    @Nullable
    public <T extends Entity> T create(EntityType<T> type, ServerLevel world, @Nullable CompoundTag itemNbt, @Nullable Component name, @Nullable Player player, BlockPos pos, MobSpawnType spawnReason, boolean alignPosition, boolean invertY) {
        double offsetY;
        if (type == null) {
            return null;
        }
        Entity entity = type.m_20615_((Level)world);
        if (entity == null) {
            return null;
        }
        if (alignPosition) {
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0);
            offsetY = SpawnerAction.getOriginY((LevelReader)world, pos, invertY, entity.m_142469_());
        } else {
            offsetY = 0.0;
        }
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5, Mth.m_14177_((float)(world.f_46441_.nextFloat() * 360.0f)), 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.f_20885_ = mob.m_146908_();
            mob.f_20883_ = mob.m_146908_();
            mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(mob.m_142538_()), spawnReason, null, itemNbt);
        }
        if (name != null && entity instanceof LivingEntity) {
            entity.m_6593_(name);
        }
        EntityType.m_20620_((Level)world, (Player)player, (Entity)entity, (CompoundTag)itemNbt);
        return (T)entity;
    }

    protected static double getOriginY(LevelReader world, BlockPos pos, boolean invertY, AABB boundingBox) {
        AABB box = new AABB(pos);
        if (invertY) {
            box = box.m_82363_(0.0, -1.0, 0.0);
        }
        Iterable iterable = world.m_186431_(null, box);
        return 1.0 + Shapes.m_193135_((Direction.Axis)Direction.Axis.Y, (AABB)boundingBox, (Iterable)iterable, (double)(invertY ? -2.0 : -1.0));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpawnerAction)) {
            return false;
        }
        SpawnerAction action = (SpawnerAction)other;
        return this.getPos().equals((Object)action.getPos()) && this.getSide() == action.getSide();
    }

    public int hashCode() {
        return this.getSide().ordinal() * 31 + this.getPos().hashCode();
    }
}

