/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.world.spawner;

import iskallia.ispawner.block.SpawnerBlock;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.init.ModBlocks;
import iskallia.ispawner.nbt.INBTSerializable;
import iskallia.ispawner.util.WeightedList;
import iskallia.ispawner.world.spawner.SpawnerAction;
import iskallia.ispawner.world.spawner.SpawnerContext;
import iskallia.ispawner.world.spawner.SpawnerExecution;
import iskallia.ispawner.world.spawner.SpawnerSettings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class SpawnerManager
implements INBTSerializable<CompoundTag> {
    public WeightedList<SpawnerAction> actions = new WeightedList();
    public SpawnerSettings settings = new SpawnerSettings();
    public int spawnTimer;
    public int usesLeft = -1;
    public int waveCounter;
    public Map<UUID, Double> attemptModifiers = new HashMap<UUID, Double>();
    public boolean consumeCharge;

    public void addAction(SpawnerAction action, int weight) {
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            WeightedList.Entry entry = (WeightedList.Entry)iterator.next();
            if (!((SpawnerAction)entry.value).equals(action)) continue;
            entry.weight += weight;
            if (entry.weight <= 0) {
                iterator.remove();
            }
            return;
        }
        if (weight > 0) {
            this.actions.add(action, weight);
        }
    }

    public void tick(Level world, Random random, SpawnerBlockEntity entity, SpawnerExecution execution) {
        Player closestPlayer;
        BlockPos pos = entity.m_58899_();
        if (this.settings.getPlayerRadius() > 0 && (closestPlayer = world.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)this.settings.getPlayerRadius(), false)) == null) {
            return;
        }
        if (this.settings.getSpawnDelay() < 0) {
            return;
        }
        int power = world.m_46755_(pos);
        if (this.settings.getMode() == SpawnerSettings.Mode.ALWAYS_ON || this.settings.getMode() == SpawnerSettings.Mode.REDSTONE_ON && power > 0) {
            boolean shouldSpawn = this.spawnTimer == 0;
            this.spawnTimer = Mth.m_14045_((int)this.spawnTimer, (int)0, (int)this.settings.spawnDelay);
            int n = this.spawnTimer = shouldSpawn ? this.settings.spawnDelay : this.spawnTimer - 1;
            if (!shouldSpawn) {
                return;
            }
            this.spawn(world, random, entity, execution);
            this.tickUses(world, pos);
            ++this.waveCounter;
        }
    }

    private void tickUses(Level world, BlockPos pos) {
        if (this.usesLeft < 0) {
            return;
        }
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11874_, SoundSource.BLOCKS, 0.2f, 0.2f);
        world.m_142052_(pos, ((SpawnerBlock)((Object)ModBlocks.SPAWNER.get())).m_49966_());
        if (--this.usesLeft != 0) {
            return;
        }
        world.m_46961_(pos, false);
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.2f, 0.2f);
    }

    public void spawn(Level world, Random random, SpawnerBlockEntity entity, SpawnerExecution execution) {
        double baseAttempts;
        if (this.actions.isEmpty()) {
            return;
        }
        WeightedList pool = new WeightedList();
        IntStream.range(0, entity.inventory.m_6643_()).mapToObj(i -> new Entry(i, entity.inventory.m_8020_(i).m_41777_())).filter(entry -> !entry.stack.m_41619_()).forEach(entry -> pool.add(entry, entry.stack.m_41613_()));
        if (pool.isEmpty()) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        HashMap entityMap = new HashMap();
        BoundingBox spawnerBox = BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos);
        world.m_45933_(null, AABB.m_82321_((BoundingBox)spawnerBox).m_82400_((double)this.settings.getCheckRadius())).forEach(e -> {
            MobCategory spawnGroup = e.m_6095_().m_20674_();
            entityMap.put(spawnGroup, entityMap.getOrDefault(spawnGroup, 0) + 1);
        });
        for (Map.Entry entry2 : entityMap.entrySet()) {
            int limit = this.settings.getCapRestrictions().get(entry2.getKey()).limit;
            if (limit <= 0 || (Integer)entry2.getValue() < limit) continue;
            return;
        }
        double attempts = baseAttempts = (double)this.settings.getAttempts();
        for (double modifier : this.attemptModifiers.values()) {
            attempts += baseAttempts * modifier;
        }
        while (attempts > 0.0 && (double)random.nextFloat() < attempts) {
            Entry entry3 = (Entry)pool.getRandom(random);
            if (entity.canUseCharge(entry3.stack, entry3.index)) {
                boolean result;
                int retries = 6;
                while (!(result = this.actions.getRandom(random).toAbsolute(entity.getCenterPos(), entity.getRotation(), entity.getMirror()).execute(world, entry3.stack.m_41777_(), new SpawnerContext(execution, entity))) && retries-- > 0) {
                }
                if (result) {
                    if (this.consumeCharge) {
                        entry3.stack.m_41774_(1);
                    }
                    entity.onChargeUsed(entry3.stack, entry3.index);
                }
            }
            attempts -= 1.0;
        }
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag actionsList = new ListTag();
        this.actions.forEach(entry -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Action", (Tag)((SpawnerAction)entry.value).writeToNBT());
            tag.m_128405_("Weight", entry.weight);
            actionsList.add((Object)tag);
        });
        nbt.m_128365_("Actions", (Tag)actionsList);
        nbt.m_128365_("Settings", (Tag)this.settings.writeToNBT());
        nbt.m_128405_("SpawnTimer", this.spawnTimer);
        if (this.usesLeft >= 0) {
            nbt.m_128405_("UsesLeft", this.usesLeft);
        }
        nbt.m_128405_("WaveCounter", this.waveCounter);
        CompoundTag attemptModifiers = new CompoundTag();
        this.attemptModifiers.forEach((uuid, modifier) -> attemptModifiers.m_128347_(uuid.toString(), modifier.doubleValue()));
        nbt.m_128365_("AttemptModifiers", (Tag)attemptModifiers);
        nbt.m_128379_("ConsumeCharge", this.consumeCharge);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.actions.clear();
        ListTag actionsList = nbt.m_128437_("Actions", 10);
        IntStream.range(0, actionsList.size()).mapToObj(arg_0 -> ((ListTag)actionsList).m_128728_(arg_0)).forEach(tag -> {
            SpawnerAction action = new SpawnerAction();
            action.readFromNBT(tag.m_128469_("Action"));
            this.actions.add(action, tag.m_128451_("Weight"));
        });
        this.settings.readFromNBT(nbt.m_128469_("Settings"));
        this.spawnTimer = nbt.m_128451_("SpawnTimer");
        this.usesLeft = nbt.m_128425_("UsesLeft", 3) ? nbt.m_128451_("UsesLeft") : -1;
        this.waveCounter = nbt.m_128451_("WaveCounter");
        this.attemptModifiers.clear();
        CompoundTag attemptModifiers = nbt.m_128469_("AttemptModifiers");
        attemptModifiers.m_128431_().forEach(uuid -> this.attemptModifiers.put(UUID.fromString(uuid), attemptModifiers.m_128459_(uuid)));
        this.consumeCharge = nbt.m_128471_("ConsumeCharge");
    }

    public static class Entry {
        public int index;
        public ItemStack stack;

        public Entry(int index, ItemStack stack) {
            this.index = index;
            this.stack = stack;
        }
    }
}

