/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.blocks;

import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.data.ChunkData;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.registry.ChunkyTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderBlock
extends BaseEntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public ChunkLoaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChunkLoaderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : ChunkLoaderBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ChunkyRegistry.CHUNK_LOADER_ENTITY.get()), ChunkLoaderBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
            blockEntity2.addPlayer(player.m_142081_());
            blockEntity2.enableChunkLoading();
        }
        return InteractionResult.CONSUME;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState state1, boolean p_60570_) {
        if (!level.f_46443_) {
            ChunkData data = ChunkData.get(level);
            data.addChunkLoaderPosition(level, pos);
            data.m_77762_();
        }
        super.m_6807_(state, level, pos, state1, p_60570_);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_51542_) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ChunkLoaderBlockEntity) {
                ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
                blockEntity2.disableChunkLoader();
                ChunkData data = ChunkData.get(level);
                data.removeChunkLoaderPosition(level, pos);
                data.m_77762_();
            }
            super.m_6810_(state, level, pos, newState, p_51542_);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{ENABLED});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        boolean flag = level.m_46753_(pos);
        if (flag && ((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
            blockEntity2.clearPlayerCache();
            blockEntity2.unloadChunks();
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag flag) {
        super.m_5871_(stack, blockGetter, components, flag);
        components.add((Component)new TextComponent("Chunk Loader").m_130940_(ChatFormatting.YELLOW));
        components.add((Component)new TextComponent(" "));
        if (Screen.m_96638_()) {
            ITag tag;
            components.add((Component)new TranslatableComponent("chunkymcchunkface.extend.text").m_130940_(ChatFormatting.GOLD));
            ITagManager tags = ForgeRegistries.BLOCKS.tags();
            if (tags != null && (tag = tags.getTag(ChunkyTags.UPGRADE_BLOCKS)).size() > 0) {
                int index = (int)(System.currentTimeMillis() / 1000L % (long)tag.size());
                Block randomBlock = (Block)tag.stream().toArray()[index];
                MutableComponent blockName = new TranslatableComponent(randomBlock.m_7705_()).m_130940_(ChatFormatting.WHITE);
                components.add((Component)new TranslatableComponent("chunkymcchunkface.blocks.text", new Object[]{blockName}).m_130940_(ChatFormatting.GREEN));
            }
        } else {
            components.add((Component)new TranslatableComponent("chunkymcchunkface.shift.text").m_130940_(ChatFormatting.GRAY));
        }
    }
}

