/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.compat.jade;

import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.config.ChunkyConfig;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaClientRegistration;
import mcp.mobius.waila.api.IWailaCommonRegistration;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation SHOW_TIME = new ResourceLocation("chunkymcchunkface", "show_time");

    public void register(IWailaCommonRegistration registration) {
        registration.addConfig(SHOW_TIME, true);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerComponentProvider((IComponentProvider)ChunkLoaderTimeProvider.INSTANCE, TooltipPosition.BODY, ChunkLoaderBlock.class);
    }

    public static enum ChunkLoaderTimeProvider implements IComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig pluginConfig) {
            ChunkLoaderBlockEntity blockEntity;
            BlockEntity blockEntity2;
            if (pluginConfig.get(SHOW_TIME) && (blockEntity2 = blockAccessor.getBlockEntity()) instanceof ChunkLoaderBlockEntity && (blockEntity = (ChunkLoaderBlockEntity)blockEntity2).isEnabled()) {
                if (blockEntity.getPlayerOnlineCache()) {
                    tooltip.add((Component)new TranslatableComponent("chunkymcchunkface.waila.time.online"));
                } else {
                    int configuredTicks = (Integer)ChunkyConfig.COMMON.offlineTime.get();
                    if (configuredTicks != 0) {
                        long lastSeen = blockEntity.getLastSeenCache();
                        long ticksActive = blockEntity.m_58904_().m_46467_() - lastSeen;
                        int ticksLeft = configuredTicks - (int)ticksActive;
                        int seconds = ticksLeft / 20;
                        tooltip.add((Component)new TranslatableComponent("chunkymcchunkface.waila.time.remaining", new Object[]{seconds}));
                    } else {
                        tooltip.add((Component)new TranslatableComponent("chunkymcchunkface.waila.time.disabled"));
                    }
                }
            }
        }
    }
}

