/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.diffuser.DiffuserUpgradeConfig;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.drop.DropUpgradeConfig;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.identify.IdentificationUpgradeConfig;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.opener.OpenerUpgradeConfig;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.recycler.RecyclerUpgradeConfig;

public class Config {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    private Config() {
    }

    static {
        Pair serverSpec = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpec.getRight();
        SERVER = (Server)serverSpec.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Integer> debagnetizerRange;
        public final DiffuserUpgradeConfig diffuserUpgrade;
        public final DiffuserUpgradeConfig advancedDiffuserUpgradeConfig;
        public final RecyclerUpgradeConfig recyclerUpgradeConfig;
        public final RecyclerUpgradeConfig advancedRecyclerUpgradeConfig;
        public final DropUpgradeConfig dropUpgradeConfig;
        public final DropUpgradeConfig advancedDropUpgradeConfig;
        public final IdentificationUpgradeConfig advancedIdentificationUpgradeConfig;
        public final IdentificationUpgradeConfig identificationUpgradeConfig;
        public final OpenerUpgradeConfig openerUpgradeConfig;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server Settings").push("server");
            this.debagnetizerRange = builder.comment("Range that a Debagnetizer will effect pickup upgrades.").define("Debagnetizer Range", (Object)32);
            this.diffuserUpgrade = new DiffuserUpgradeConfig(builder, "Diffuser Upgrade", "diffuserUpgrade", 9, 3);
            this.advancedDiffuserUpgradeConfig = new DiffuserUpgradeConfig(builder, "Advanced Diffuser Upgrade", "advancedDiffuserUpgrade", 16, 4);
            this.recyclerUpgradeConfig = new RecyclerUpgradeConfig(builder, "Recycler Upgrade", "recyclerUpgrade", 9, 3);
            this.advancedRecyclerUpgradeConfig = new RecyclerUpgradeConfig(builder, "Advanced Recycler Upgrade", "advancedRecyclerUpgrade", 16, 4);
            this.dropUpgradeConfig = new DropUpgradeConfig(builder, "Drop Upgrade", "dropUpgrade", 9, 3);
            this.advancedDropUpgradeConfig = new DropUpgradeConfig(builder, "Advanced Drop Upgrade", "advancedDropUpgrade", 16, 4);
            this.identificationUpgradeConfig = new IdentificationUpgradeConfig(builder, "Identification Upgrade", "IdentificationUpgrade", 9, 4);
            this.advancedIdentificationUpgradeConfig = new IdentificationUpgradeConfig(builder, "Advanced Identification Upgrade", "advancedIdentificationUpgrade", 16, 4);
            this.openerUpgradeConfig = new OpenerUpgradeConfig(builder, "Opener Upgrade", "openerUpgrade", 9, 3);
            builder.pop();
        }
    }
}

