/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.activation;

import iskallia.vault.block.ScavengerAltarBlock;
import iskallia.vault.block.TreasureDoorBlock;
import iskallia.vault.block.entity.ScavengerAltarTileEntity;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class ActivationUpgradeLogic {
    public static boolean tryOpenTreasureDoor(Player player, Level world, BlockState blockState, BlockPos blockPos, TreasureDoorBlock door, IStorageWrapper storageWrapper) {
        HashSet itemsToRemove = new HashSet();
        boolean isOpen = door.m_52815_(blockState);
        if (!isOpen) {
            storageWrapper.getInventoryForUpgradeProcessing().getTrackedStacks().forEach(itemStackKey -> {
                if (itemStackKey.getStack().m_41720_() == ((TreasureDoorBlock.Type)blockState.m_61143_((Property)TreasureDoorBlock.TYPE)).getKey()) {
                    itemsToRemove.add(itemStackKey);
                    door.m_153165_((Entity)player, world, blockState, blockPos, true);
                    CommonEvents.BLOCK_USE_MERGED.invoke(world, player, InteractionHand.MAIN_HAND, null, PartialTile.of((BlockState)blockState), PartialTile.of((BlockState)world.m_8055_(blockPos)));
                    CommonEvents.TREASURE_ROOM_OPEN.invoke(world, player, blockPos);
                }
            });
            for (ItemStackKey key : itemsToRemove) {
                InventoryHelper.extractFromInventory((ItemStack)key.stack(), (IItemHandler)storageWrapper.getInventoryForUpgradeProcessing(), (boolean)false);
            }
            return true;
        }
        return false;
    }

    public static boolean tryAddingToScavAltar(Player player, Level world, BlockPos blockPos, ScavengerAltarBlock altar, IStorageWrapper storageWrapper) {
        block6: {
            Iterator iterator;
            HashSet<ItemStack> validScavItems = new HashSet<ItemStack>();
            Optional optionalVault = ServerVaults.get((Level)world);
            if (optionalVault.isPresent()) {
                Vault vault = (Vault)optionalVault.get();
                Listener listener = ((Listeners)vault.get(Vault.LISTENERS)).get(player.m_142081_());
                if (listener == null) {
                    return false;
                }
                Iterator vaultObjectives = listener.getObjectives(vault);
                ScavengerObjective scavObj = null;
                while (vaultObjectives.hasNext()) {
                    ScavengerObjective obj;
                    Object e = vaultObjectives.next();
                    if (!(e instanceof ScavengerObjective)) continue;
                    scavObj = obj = (ScavengerObjective)e;
                }
                if (scavObj != null) {
                    ScavengerObjective.GoalMap goalMap = (ScavengerObjective.GoalMap)scavObj.get(ScavengerObjective.GOALS);
                    List goals = (List)goalMap.get(listener.get(Listener.ID));
                    for (ScavengerGoal goal : goals) {
                        if (goal.isCompleted()) continue;
                        int stackSize = (Integer)goal.get(ScavengerGoal.TOTAL) - (Integer)goal.get(ScavengerGoal.CURRENT);
                        Iterator entries = goal.getEntries();
                        while (entries.hasNext()) {
                            ScavengerGoal.Entry entry = (ScavengerGoal.Entry)entries.next();
                            validScavItems.add(entry.getStack(stackSize));
                        }
                    }
                }
            }
            if (validScavItems.isEmpty() || !(iterator = validScavItems.iterator()).hasNext()) break block6;
            ItemStack scavStack = (ItemStack)iterator.next();
            ActivationUpgradeLogic.useScavAltar(world, blockPos, player, InventoryHelper.extractFromInventory((ItemStack)scavStack, (IItemHandler)storageWrapper.getInventoryHandler(), (boolean)false).m_41777_());
        }
        return true;
    }

    public static boolean useScavAltar(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof ScavengerAltarTileEntity) {
            ScavengerAltarTileEntity tile = (ScavengerAltarTileEntity)tileEntity;
            if (stack.m_41619_()) {
                return false;
            }
            tile.setHeldItem(stack);
            tile.setItemPlacedBy(player.m_142081_());
            tile.ticksToConsume = 40;
            tile.consuming = false;
            world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
            tile.m_6596_();
            world.m_7260_(pos, tile.m_58900_(), tile.m_58900_(), 3);
            return true;
        }
        return false;
    }
}

