/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.diffuser;

import iskallia.vault.init.ModItems;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.diffuser.DiffuserUpgradeHelper;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.diffuser.DiffuserUpgradeItem;

public class DiffuserUpgradeWrapper
extends UpgradeWrapperBase<DiffuserUpgradeWrapper, DiffuserUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private final Set<Integer> remainderSlotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;
    private static final int INSERTING_COOLDOWN = 10;
    private static final int SHARD_POUCH_COOLDOWN = 20;

    public DiffuserUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((DiffuserUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.setShouldVoidOverflowDefaultOrLoadFromNbt(false);
    }

    @NotNull
    public ItemStack onBeforeInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41720_().equals(ModItems.SOUL_DUST) || stack.m_41720_().equals(ModItems.SOUL_SHARD) || !this.hasSlotSpace()) {
            return stack;
        }
        if (this.shouldVoidOverflow && inventoryHandler.getStackInSlot(slot).m_41619_() && (!this.filterLogic.shouldMatchNbt() || !this.filterLogic.shouldMatchDurability() || this.filterLogic.getPrimaryMatch() != PrimaryMatch.ITEM) && this.filterLogic.matchesFilter(stack)) {
            for (int s = 0; s < inventoryHandler.getSlots(); ++s) {
                if (s == slot || !this.stackMatchesFilterStack(inventoryHandler.getStackInSlot(s), stack)) continue;
                ItemStack remainderStack = this.insertDiffusedDust((InventoryHandler)inventoryHandler, slot, stack, simulate, false);
                if (remainderStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                return remainderStack;
            }
            return stack;
        }
        if (!this.shouldVoidOverflow && this.filterLogic.matchesFilter(stack) && DiffuserUpgradeHelper.getDiffuserValue(stack) != 0) {
            ItemStack remainderStack = this.insertDiffusedDust((InventoryHandler)inventoryHandler, slot, stack, simulate, false);
            if (remainderStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            return remainderStack;
        }
        return stack;
    }

    public void onAfterInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot) {
    }

    @NotNull
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI", (boolean)shouldWorkdInGUI);
        this.save();
    }

    public void setShouldHoldShards(boolean shouldHoldShards) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldHoldShards", (boolean)shouldHoldShards);
        this.save();
    }

    public void setShouldCompactShards(boolean shouldHoldShards) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldCompactShards", (boolean)shouldHoldShards);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI").orElse(false);
    }

    public boolean isShouldCompactShards() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldCompactShards").orElse(false);
    }

    public boolean isShouldHoldShards() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldHoldShards").orElse(false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        if (!shouldVoidOverflow && !((DiffuserUpgradeItem)this.upgradeItem).isVoidAnythingEnabled()) {
            return;
        }
        this.shouldVoidOverflow = shouldVoidOverflow;
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldVoidOverflow", (boolean)shouldVoidOverflow);
        this.save();
    }

    public void setShouldVoidOverflowDefaultOrLoadFromNbt(boolean shouldVoidOverflowDefault) {
        this.shouldVoidOverflow = !((DiffuserUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldVoidOverflow").orElse(shouldVoidOverflowDefault) != false;
    }

    public boolean shouldVoidOverflow() {
        return !((DiffuserUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || this.shouldVoidOverflow;
    }

    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack) && DiffuserUpgradeHelper.getDiffuserValue(slotStack) != 0) {
            this.slotsToVoid.add(slot);
        }
    }

    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            int soulValue;
            ItemStack stack = storageInventory.getStackInSlot(slot);
            if (this.stackMatchesFilter(stack) && !stack.m_41720_().equals(ModItems.SOUL_DUST) && !stack.m_41720_().equals(ModItems.SOUL_SHARD) && (soulValue = DiffuserUpgradeHelper.getDiffuserValue(stack)) != 0 && !this.insertDiffusedDust(storageInventory, slot, stack, false, true).m_41619_()) continue;
        }
        if (!this.remainderSlotsToVoid.isEmpty()) {
            List remainderSlotList = this.remainderSlotsToVoid.stream().toList();
            for (int i = 0; i < remainderSlotList.size(); ++i) {
                int slot = (Integer)remainderSlotList.get(i);
                if (this.slotsToVoid.contains(slot)) continue;
                ItemStack slotStack = storageInventory.getStackInSlot(slot);
                if (!slotStack.m_41619_() && this.stackMatchesFilter(slotStack)) {
                    if (!this.insertDiffusedDust(storageInventory, slot, slotStack, false, true).m_41619_()) continue;
                    this.remainderSlotsToVoid.remove(slot);
                    continue;
                }
                this.remainderSlotsToVoid.remove(slot);
            }
        }
        this.setCooldown(world, 10);
        if (this.shouldCompactShards()) {
            this.tryCompacting(storageInventory, false);
        }
        if (this.shouldHoldShards()) {
            return;
        }
        if (entity == null) {
            world.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(pos).m_82400_(3.0), p -> true).forEach(p -> DiffuserUpgradeHelper.tryAndAddShardsToPouch(this.storageWrapper, p));
        } else {
            DiffuserUpgradeHelper.tryAndAddShardsToPouch(this.storageWrapper, (Player)entity);
        }
        this.setCooldown(world, 20);
    }

    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    public boolean shouldHoldShards() {
        return this.isShouldHoldShards();
    }

    public boolean shouldCompactShards() {
        return this.isShouldCompactShards();
    }

    @NotNull
    public ItemStack onOverflow(@NotNull ItemStack stack) {
        return stack;
    }

    public boolean stackMatchesFilter(@NotNull ItemStack stack) {
        if (stack.m_41720_().equals(ModItems.SOUL_DUST) || stack.m_41720_().equals(ModItems.SOUL_SHARD)) {
            return this.filterLogic.isAllowList();
        }
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAnythingEnabled() {
        return ((DiffuserUpgradeItem)this.upgradeItem).isVoidAnythingEnabled();
    }

    private void tryCompacting(InventoryHandler inventoryHandler, boolean simulate) {
        ItemStack shardStack;
        ItemStack dustStack;
        AtomicInteger totalDust = new AtomicInteger();
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            if (stack.m_150930_((Item)ModItems.SOUL_DUST)) {
                totalDust.addAndGet(stack.m_41613_());
            }
        });
        if (totalDust.get() < 9) {
            return;
        }
        Pair<Integer, Integer> shardDustPair = DiffuserUpgradeWrapper.getDustAndShardPair(totalDust.get());
        ItemStack existingDust = new ItemStack((ItemLike)ModItems.SOUL_DUST, totalDust.get());
        if (this.canFitResultingDust((IItemHandler)inventoryHandler, existingDust, dustStack = new ItemStack((ItemLike)ModItems.SOUL_DUST, ((Integer)shardDustPair.getRight()).intValue()), shardStack = new ItemStack((ItemLike)ModItems.SOUL_SHARD, ((Integer)shardDustPair.getLeft()).intValue()), true)) {
            InventoryHelper.extractFromInventory((Item)ModItems.SOUL_DUST, (int)totalDust.get(), (IItemHandler)inventoryHandler, (boolean)simulate);
            inventoryHandler.insertItem(shardStack, simulate);
            inventoryHandler.insertItem(dustStack, simulate);
        }
    }

    private boolean canFitResultingDust(IItemHandler inventoryHandler, ItemStack diffuseStack, ItemStack dustStack, ItemStack shardStack, boolean extractDiffuseStackBeforeInsert) {
        if (!diffuseStack.m_41619_()) {
            IItemHandler clonedHandler = InventoryHelper.cloneInventory((IItemHandler)inventoryHandler);
            if (extractDiffuseStackBeforeInsert) {
                InventoryHelper.extractFromInventory((ItemStack)diffuseStack, (IItemHandler)clonedHandler, (boolean)true);
            }
            if (InventoryHelper.insertIntoInventory((ItemStack)dustStack, (IItemHandler)clonedHandler, (boolean)false).m_41619_() && InventoryHelper.insertIntoInventory((ItemStack)shardStack, (IItemHandler)clonedHandler, (boolean)false).m_41619_()) {
                return true;
            }
        }
        return InventoryHelper.insertIntoInventory((ItemStack)dustStack, (IItemHandler)inventoryHandler, (boolean)true).m_41619_() && InventoryHelper.insertIntoInventory((ItemStack)shardStack, (IItemHandler)inventoryHandler, (boolean)true).m_41619_();
    }

    private boolean canFitResultingDust(IItemHandler inventoryHandler, ItemStack diffuseStack, ItemStack dustStack, ItemStack shardStack) {
        return this.canFitResultingDust(inventoryHandler, diffuseStack, dustStack, shardStack, false);
    }

    public ItemStack insertDiffusedDust(InventoryHandler inventoryHandler, int slot, ItemStack stackToDiffuse, boolean simulate, boolean shouldExtractDiffuseStack) {
        ItemStack dustStack;
        if (stackToDiffuse.m_41619_() || stackToDiffuse.m_41720_().equals(ModItems.SOUL_DUST) || stackToDiffuse.m_41720_().equals(ModItems.SOUL_SHARD)) {
            return stackToDiffuse;
        }
        int soulValue = DiffuserUpgradeHelper.getDiffuserValue(stackToDiffuse);
        int itemCount = stackToDiffuse.m_41613_();
        int totalValue = soulValue * itemCount;
        ItemStack shardStack = ItemStack.f_41583_;
        boolean inserted = false;
        if (soulValue == 0) {
            return stackToDiffuse;
        }
        if (this.shouldCompactShards()) {
            Pair<Integer, Integer> dustShardPair = DiffuserUpgradeWrapper.getDustAndShardPair(totalValue);
            dustStack = new ItemStack((ItemLike)ModItems.SOUL_DUST, ((Integer)dustShardPair.getRight()).intValue());
            shardStack = new ItemStack((ItemLike)ModItems.SOUL_SHARD, ((Integer)dustShardPair.getLeft()).intValue());
        } else {
            dustStack = new ItemStack((ItemLike)ModItems.SOUL_DUST, totalValue);
        }
        if (this.canFitResultingDust((IItemHandler)inventoryHandler, stackToDiffuse, dustStack, shardStack)) {
            if (!shardStack.m_41619_()) {
                inventoryHandler.insertItem(shardStack, simulate);
            }
            inventoryHandler.insertItem(dustStack, simulate);
            inserted = true;
        }
        if (inserted) {
            if (shouldExtractDiffuseStack) {
                inventoryHandler.extractItem(slot, itemCount, simulate);
            }
            return ItemStack.f_41583_;
        }
        if (this.shouldCompactShards()) {
            Pair<Integer, Integer> shardDustPair = DiffuserUpgradeWrapper.getDustAndShardPair(soulValue);
            dustStack = new ItemStack((ItemLike)ModItems.SOUL_DUST, ((Integer)shardDustPair.getRight()).intValue());
            shardStack = new ItemStack((ItemLike)ModItems.SOUL_SHARD, ((Integer)shardDustPair.getLeft()).intValue());
        } else {
            dustStack = new ItemStack((ItemLike)ModItems.SOUL_DUST, soulValue);
            shardStack = ItemStack.f_41583_;
        }
        if (this.canFitResultingDust((IItemHandler)inventoryHandler, stackToDiffuse, dustStack, shardStack)) {
            inventoryHandler.insertItem(shardStack, simulate);
            inventoryHandler.insertItem(dustStack, simulate);
            if (shouldExtractDiffuseStack) {
                inventoryHandler.extractItem(slot, 1, simulate);
                this.remainderSlotsToVoid.add(slot);
                return ItemStack.f_41583_;
            }
        }
        return stackToDiffuse;
    }

    public ItemStack insertDiffusedDust(InventoryHandler inventoryHandler, ItemStack stackToDiffuse, boolean simulate) {
        return this.insertDiffusedDust(inventoryHandler, -1, stackToDiffuse, simulate, false);
    }

    public static Pair<Integer, Integer> getDustAndShardPair(int totalValue) {
        int shardValue = totalValue / 9;
        int dustValue = totalValue % 9;
        return Pair.of((Object)shardValue, (Object)dustValue);
    }

    private boolean hasSlotSpace() {
        InventoryHandler handler = this.storageWrapper.getInventoryHandler();
        Predicate hasItemPredicate = Predicate.not(Predicate.isEqual(ItemStack.f_41583_));
        if (!handler.hasEmptySlots()) {
            return false;
        }
        return handler.getSlots() - InventoryHelper.getItemSlots((IItemHandler)handler, hasItemPredicate).size() > 2;
    }
}

