/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.drop;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.drop.DropUpgradeHelper;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.drop.DropUpgradeItem;

public class DropUpgradeWrapper
extends UpgradeWrapperBase<DropUpgradeWrapper, DropUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;

    public DropUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((DropUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.setShouldVoidOverflowDefaultOrLoadFromNbt(false);
    }

    @NotNull
    public ItemStack onBeforeInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    public void onAfterInsert(@NotNull IItemHandlerSimpleInserter inventoryHandler, int slot) {
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @NotNull
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI", (boolean)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldWorkInGUI").orElse(false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        if (!shouldVoidOverflow && !((DropUpgradeItem)this.upgradeItem).isVoidAnythingEnabled()) {
            return;
        }
        this.shouldVoidOverflow = shouldVoidOverflow;
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldVoidOverflow", (boolean)shouldVoidOverflow);
        this.save();
    }

    public void setShouldVoidOverflowDefaultOrLoadFromNbt(boolean shouldVoidOverflowDefault) {
        this.shouldVoidOverflow = !((DropUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldVoidOverflow").orElse(shouldVoidOverflowDefault) != false;
    }

    public boolean shouldVoidOverflow() {
        return !((DropUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || this.shouldVoidOverflow;
    }

    public void onSlotChange(@NotNull IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    public void tick(@Nullable LivingEntity entity, @NotNull Level world, @NotNull BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            if (!this.stackMatchesFilter(storageInventory.getStackInSlot(slot))) continue;
            DropUpgradeHelper.dropStackAtPosition(storageInventory, slot, world, pos, false);
        }
        this.slotsToVoid.clear();
    }

    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @NotNull
    public ItemStack onOverflow(@NotNull ItemStack stack) {
        return stack;
    }

    public boolean stackMatchesFilter(@NotNull ItemStack stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAnythingEnabled() {
        return ((DropUpgradeItem)this.upgradeItem).isVoidAnythingEnabled();
    }
}

