/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvaultupgrades.upgrades.identify;

import com.mojang.authlib.GameProfile;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.item.JewelPouchItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import org.jetbrains.annotations.NotNull;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.IDimensionChangeResponseUpgrade;
import xyz.iwolfking.sophisticatedvaultupgrades.upgrades.identify.IdentificationUpgradeItem;

public class IdentificationUpgradeWrapper
extends UpgradeWrapperBase<IdentificationUpgradeWrapper, IdentificationUpgradeItem>
implements IPickupResponseUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IDimensionChangeResponseUpgrade,
IInsertResponseUpgrade {
    private final Set<Integer> slotsToIdentify = new HashSet<Integer>();
    boolean shouldRunIdentify = true;
    private final ItemStack upgradeStack;
    private final FilterLogic filterLogic;
    private final Map<Integer, Integer> SLOT_HASHMAP = new HashMap<Integer, Integer>();
    private static final int IDENTIFICATION_COOLDOWN = 20;

    public IdentificationUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.upgradeStack = upgrade;
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((IdentificationUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    @NotNull
    public ItemStack pickup(@NotNull Level level, @NotNull ItemStack itemStack, boolean simulate) {
        if (!this.shouldWorkInVault() && this.isInVault(level)) {
            return itemStack;
        }
        if (!simulate && this.matchesFilter(itemStack)) {
            this.tryIdentifyItem(itemStack, level);
        }
        return itemStack;
    }

    public void tick(LivingEntity entity, Level world, BlockPos pos) {
        if (!this.shouldRunIdentify || this.isInCooldown(world)) {
            return;
        }
        if (!this.shouldWorkInVault() && this.isInVault(world)) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot = 0; slot < this.storageWrapper.getInventoryHandler().getSlots(); ++slot) {
            ItemStack stack = storageInventory.getStackInSlot(slot);
            if (!this.matchesFilter(stack, slot)) continue;
            this.tryIdentifyItem(stack, slot, world, (Entity)entity, storageInventory);
        }
        this.setCooldown(world, 20);
        this.shouldRunIdentify = false;
    }

    public boolean matchesFilter(ItemStack stack) {
        return this.matchesFilter(stack, -1);
    }

    public boolean matchesFilter(ItemStack stack, int slot) {
        if (this.SLOT_HASHMAP.containsKey(slot) && this.SLOT_HASHMAP.get(slot).equals(stack.hashCode())) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof IdentifiableItem) {
            IdentifiableItem gear = (IdentifiableItem)item;
            if (this.filterLogic.matchesFilter(stack) && !(stack.m_41720_() instanceof JewelPouchItem)) {
                boolean isUnidentified = gear.getState(stack).equals((Object)VaultGearState.UNIDENTIFIED);
                this.SLOT_HASHMAP.put(slot, stack.hashCode());
                return isUnidentified;
            }
        }
        return false;
    }

    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        this.shouldRunIdentify = true;
    }

    public boolean hasOwner() {
        IdentificationUpgradeItem identificationUpgradeItem;
        Item item = this.upgradeStack.m_41720_();
        return item instanceof IdentificationUpgradeItem && (identificationUpgradeItem = (IdentificationUpgradeItem)item).getOwnerID(this.upgradeStack) != null;
    }

    public static boolean hasOwner(ItemStack upgradeStack) {
        IdentificationUpgradeItem identificationUpgradeItem;
        Item item = upgradeStack.m_41720_();
        return item instanceof IdentificationUpgradeItem && (identificationUpgradeItem = (IdentificationUpgradeItem)item).getOwnerID(upgradeStack) != null;
    }

    public Player getOwner(Level world) {
        if (this.hasOwner()) {
            IdentificationUpgradeItem upgradeItem = (IdentificationUpgradeItem)this.upgradeStack.m_41720_();
            MinecraftServer server = world.m_142572_();
            if (server == null) {
                return null;
            }
            try {
                if (upgradeItem.getOwnerID(this.upgradeStack) != null) {
                    GameProfile fakeProfile = new GameProfile(upgradeItem.getOwnerID(this.upgradeStack), upgradeItem.getOwnerName(this.upgradeStack));
                    return new FakePlayer((ServerLevel)world, fakeProfile);
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ItemStack tryIdentifyItem(ItemStack stack, int slot, Level world, Entity entity, InventoryHandler storageInventory) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getOwner(world) == null) {
                ItemStack identifiedStack = this.tryIdentifyItem(stack, world, player);
                storageInventory.setStackInSlot(slot, ItemStack.f_41583_);
                storageInventory.insertItem(identifiedStack, false);
                return stack.m_41777_();
            }
        }
        if (this.getOwner(world) == null) return stack.m_41777_();
        ItemStack identifiedStack = this.tryIdentifyItem(stack, world);
        storageInventory.setStackInSlot(slot, ItemStack.f_41583_);
        storageInventory.insertItem(identifiedStack, false);
        return stack.m_41777_();
    }

    private ItemStack tryIdentifyItem(ItemStack stack, Level level, Player player) {
        if (player != null) {
            Item item = stack.m_41720_();
            if (item instanceof IdentifiableItem) {
                IdentifiableItem identifiableItem = (IdentifiableItem)item;
                if (stack.m_41613_() == 1) {
                    identifiableItem.instantIdentify(player, stack);
                    return stack.m_41777_();
                }
            }
        } else {
            this.tryIdentifyItem(stack, level);
        }
        return stack.m_41777_();
    }

    private ItemStack tryIdentifyItem(ItemStack stack, Level level) {
        Player player = this.getOwner(level);
        if (player != null) {
            return this.tryIdentifyItem(stack, level, player);
        }
        return stack.m_41777_();
    }

    @Override
    public void onDimensionChange(ResourceKey<Level> from, ResourceKey<Level> to, Player player) {
        if (this.shouldWorkInVault()) {
            return;
        }
        if (from.m_135782_().m_135827_().equals("the_vault")) {
            InventoryHelper.iterate((IItemHandler)this.storageWrapper.getInventoryHandler(), (slot, stack) -> {
                IdentifiableItem identifiableItem;
                Item patt7724$temp = stack.m_41720_();
                if (patt7724$temp instanceof IdentifiableItem && (identifiableItem = (IdentifiableItem)patt7724$temp).getState(stack).equals((Object)VaultGearState.UNIDENTIFIED)) {
                    this.tryIdentifyItem((ItemStack)stack, player.m_183503_(), player);
                }
            });
        }
    }

    public void setShouldWorkInVault(boolean shouldWorkInVault) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"shouldWorkInVault", (boolean)shouldWorkInVault);
        this.save();
    }

    public boolean shouldWorkInVault() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"shouldWorkInVault").orElse(true);
    }

    public boolean isInVault(Level level) {
        return level.m_46472_().m_135782_().m_135827_().equals("the_vault");
    }

    @NotNull
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @NotNull
    public ItemStack onBeforeInsert(@NotNull IItemHandlerSimpleInserter iItemHandlerSimpleInserter, int i, @NotNull ItemStack itemStack, boolean b) {
        return itemStack;
    }

    public void onAfterInsert(IItemHandlerSimpleInserter iItemHandlerSimpleInserter, int i) {
        this.shouldRunIdentify = true;
    }
}

